package gov.va.cem.cbs.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;


/**
 * The persistent class for the URL_INFORMATION database table.
 * 
 */
@Entity
@Table(name="URL_INFORMATION")
@NamedQuery(name="UrlInformation.findAll", query="SELECT u FROM UrlInformation u")
public class UrlInformation implements Serializable {
	private static final long serialVersionUID = 1L;

	@EmbeddedId
	private UrlInformationPK id;

	@Column(name="URL_DESCR")
	private String urlDescr;

	public UrlInformation() {
	}

	public UrlInformationPK getId() {
		return this.id;
	}

	public void setId(UrlInformationPK id) {
		this.id = id;
	}

	public String getUrlDescr() {
		return this.urlDescr;
	}

	public void setUrlDescr(String urlDescr) {
		this.urlDescr = urlDescr;
	}

	@Override
	public String toString() {
		return "UrlInformation [id=" + id + ", urlDescr=" + urlDescr + "]";
	}

}