package gov.va.cem.cbs.model;

import java.io.Serializable;
import javax.persistence.*;


/**
 * The persistent class for the CEMETERY_V database table.
 * 
 */
@Entity
@Table(name="CEMETERY_V")
@NamedQuery(name="CemeteryV.findAll", query="SELECT c FROM CemeteryV c")
public class CemeteryV implements Serializable {
	private static final long serialVersionUID = 1L;

	@Column(name="CEMETERY_TYPE", insertable=false, updatable=false)
	private String cemeteryType;

	@Column(name="CITY_NME", insertable=false, updatable=false)
	private String cityNme;

	@Column(insertable=false, updatable=false)
	private String descr;

	@Column(name="LINE_ONE_ADDR", insertable=false, updatable=false)
	private String lineOneAddr;

	@Column(name="LINE_TWO_ADDR", insertable=false, updatable=false)
	private String lineTwoAddr;

	@Column(name="MANAGING_STATION_NUM", insertable=false, updatable=false)
	private String managingStationNum;

	@Column(insertable=false, updatable=false)
	private String nme;

	@Id
	@Column(insertable=false, updatable=false)
	private String num;

	@Column(name="PHONE_AREA_CODE_ONE_NUM", insertable=false, updatable=false)
	private String phoneAreaCodeOneNum;

	@Column(name="PHONE_AREA_CODE_TWO_NUM", insertable=false, updatable=false)
	private String phoneAreaCodeTwoNum;

	@Column(name="PHONE_ONE_NUM", insertable=false, updatable=false)
	private String phoneOneNum;

	@Column(name="PHONE_TWO_NUM", insertable=false, updatable=false)
	private String phoneTwoNum;

	@Column(name="STATE_CD", insertable=false, updatable=false)
	private String stateCd;

	@Column(name="ZIP_FIVE_CD", insertable=false, updatable=false)
	private String zipFiveCd;

	public CemeteryV() {
	}

	public String getCemeteryType() {
		return this.cemeteryType;
	}

	public void setCemeteryType(String cemeteryType) {
		this.cemeteryType = cemeteryType;
	}

	public String getCityNme() {
		return this.cityNme;
	}

	public void setCityNme(String cityNme) {
		this.cityNme = cityNme;
	}

	public String getDescr() {
		return this.descr;
	}

	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getLineOneAddr() {
		return this.lineOneAddr;
	}

	public void setLineOneAddr(String lineOneAddr) {
		this.lineOneAddr = lineOneAddr;
	}

	public String getLineTwoAddr() {
		return this.lineTwoAddr;
	}

	public void setLineTwoAddr(String lineTwoAddr) {
		this.lineTwoAddr = lineTwoAddr;
	}

	public String getManagingStationNum() {
		return this.managingStationNum;
	}

	public void setManagingStationNum(String managingStationNum) {
		this.managingStationNum = managingStationNum;
	}

	public String getNme() {
		return this.nme;
	}

	public void setNme(String nme) {
		this.nme = nme;
	}

	public String getNum() {
		return this.num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	public String getPhoneAreaCodeOneNum() {
		return this.phoneAreaCodeOneNum;
	}

	public void setPhoneAreaCodeOneNum(String phoneAreaCodeOneNum) {
		this.phoneAreaCodeOneNum = phoneAreaCodeOneNum;
	}

	public String getPhoneAreaCodeTwoNum() {
		return this.phoneAreaCodeTwoNum;
	}

	public void setPhoneAreaCodeTwoNum(String phoneAreaCodeTwoNum) {
		this.phoneAreaCodeTwoNum = phoneAreaCodeTwoNum;
	}

	public String getPhoneOneNum() {
		return this.phoneOneNum;
	}

	public void setPhoneOneNum(String phoneOneNum) {
		this.phoneOneNum = phoneOneNum;
	}

	public String getPhoneTwoNum() {
		return this.phoneTwoNum;
	}

	public void setPhoneTwoNum(String phoneTwoNum) {
		this.phoneTwoNum = phoneTwoNum;
	}

	public String getStateCd() {
		return this.stateCd;
	}

	public void setStateCd(String stateCd) {
		this.stateCd = stateCd;
	}

	public String getZipFiveCd() {
		return this.zipFiveCd;
	}

	public void setZipFiveCd(String zipFiveCd) {
		this.zipFiveCd = zipFiveCd;
	}

	@Override
	public String toString() {
		return "CemeteryV [cemeteryType=" + cemeteryType + ", cityNme=" + cityNme + ", descr=" + descr
				+ ", lineOneAddr=" + lineOneAddr + ", lineTwoAddr=" + lineTwoAddr + ", managingStationNum="
				+ managingStationNum + ", nme=" + nme + ", num=" + num + ", phoneAreaCodeOneNum=" + phoneAreaCodeOneNum
				+ ", phoneAreaCodeTwoNum=" + phoneAreaCodeTwoNum + ", phoneOneNum=" + phoneOneNum + ", phoneTwoNum="
				+ phoneTwoNum + ", stateCd=" + stateCd + ", zipFiveCd=" + zipFiveCd + "]";
	}

}