package gov.va.cem.cbs.model;

import java.io.Serializable;
import javax.persistence.*;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.util.Date;


/**
 * The persistent class for the BURIALSCHEDULE_V database table.
 * 
 */
@Entity
@Table(name="BURIAL_SCHEDULE_V")
@NamedQuery(name="BurialScheduleV.findAll", query="SELECT b FROM BurialScheduleV b")
public class BurialScheduleV implements Serializable {
	private static final long serialVersionUID = 1L;

	@Column(name="CEMETERY_CITY", insertable=false, updatable=false)
	private String cemeteryCity;

	@Column(name="CEMETERY_ID", insertable=false, updatable=false)
	private String cemeteryId;

	@Column(name="CEMETERY_NAME", insertable=false, updatable=false)
	private String cemeteryName;

	@Column(name="CEMETERY_STATE", insertable=false, updatable=false)
	private String cemeteryState;

	@Column(name="FIRST_NAME", insertable=false, updatable=false)
	private String firstName;

	@Column(name="FUNERAL_HOME", insertable=false, updatable=false)
	private String funeralHome;

	@Id
	@GeneratedValue(strategy=GenerationType.TABLE)
	@Column(insertable=false, updatable=false)
	private BigDecimal id;

	@Column(name="LAST_NAME", insertable=false, updatable=false)
	private String lastName;

	@Column(name="MIDDLE_NAME", insertable=false, updatable=false)
	private String middleName;

	@Temporal(TemporalType.DATE)
	@Column(name="SCHEDULED_DATE", insertable=false, updatable=false)
	private Date scheduledDate;

	@Temporal(TemporalType.DATE)
	@Column(name="SCHEDULED_DATE_TIME", insertable=false, updatable=false)
	private Date scheduledDateTime;

	@Column(name="SCHEDULED_TIME", insertable=false, updatable=false)
	private String scheduledTime;

	@Column(name="SCHEDULED_TIMESTAMP", insertable=false, updatable=false)
	private Timestamp scheduledTimestamp;

	@Column(insertable=false, updatable=false)
	private String status;

	@Column(name="\"SUFFIX\"", insertable=false, updatable=false)
	private String suffix;

	@Column(insertable=false, updatable=false)
	private String url;

	public BurialScheduleV() {
	}

	public String getCemeteryCity() {
		return this.cemeteryCity;
	}

	public void setCemeteryCity(String cemeteryCity) {
		this.cemeteryCity = cemeteryCity;
	}

	public String getCemeteryId() {
		return this.cemeteryId;
	}

	public void setCemeteryId(String cemeteryId) {
		this.cemeteryId = cemeteryId;
	}

	public String getCemeteryName() {
		return this.cemeteryName;
	}

	public void setCemeteryName(String cemeteryName) {
		this.cemeteryName = cemeteryName;
	}

	public String getCemeteryState() {
		return this.cemeteryState;
	}

	public void setCemeteryState(String cemeteryState) {
		this.cemeteryState = cemeteryState;
	}

	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getFuneralHome() {
		return this.funeralHome;
	}

	public void setFuneralHome(String funeralHome) {
		this.funeralHome = funeralHome;
	}

	public BigDecimal getId() {
		return this.id;
	}

	public void setId(BigDecimal id) {
		this.id = id;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return this.middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public Date getScheduledDate() {
		return this.scheduledDate;
	}

	public void setScheduledDate(Date scheduledDate) {
		this.scheduledDate = scheduledDate;
	}

	public Date getScheduledDateTime() {
		return this.scheduledDateTime;
	}

	public void setScheduledDateTime(Date scheduledDateTime) {
		this.scheduledDateTime = scheduledDateTime;
	}

	public String getScheduledTime() {
		return this.scheduledTime;
	}

	public void setScheduledTime(String scheduledTime) {
		this.scheduledTime = scheduledTime;
	}

	public Timestamp getScheduledTimestamp() {
		return this.scheduledTimestamp;
	}

	public void setScheduledTimestamp(Timestamp scheduledTimestamp) {
		this.scheduledTimestamp = scheduledTimestamp;
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getSuffix() {
		return this.suffix;
	}

	public void setSuffix(String suffix) {
		this.suffix = suffix;
	}

	public String getUrl() {
		return this.url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String toString() {
		return "BurialScheduleV [cemeteryCity=" + cemeteryCity + ", cemeteryId=" + cemeteryId + ", cemeteryName="
				+ cemeteryName + ", cemeteryState=" + cemeteryState + ", firstName=" + firstName + ", funeralHome="
				+ funeralHome + ", id=" + id + ", lastName=" + lastName + ", middleName=" + middleName
				+ ", scheduledDate=" + scheduledDate + ", scheduledDateTime=" + scheduledDateTime + ", scheduledTime="
				+ scheduledTime + ", scheduledTimestamp=" + scheduledTimestamp + ", status=" + status + ", suffix="
				+ suffix + ", url=" + url + "]";
	}

}