package gov.va.cem.cbs.controller;

import gov.va.cem.cbs.model.BurialScheduleV;
import gov.va.cem.cbs.model.CemeteryV;
import gov.va.cem.cbs.repo.BurialScheduleDao;
import gov.va.cem.cbs.repo.CemeteryDao;
import gov.va.cem.cbs.repo.UrlInformationDao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class BurialScheduleViewController {
	private static final Logger logger = LoggerFactory.getLogger(BurialScheduleViewController.class);
	
	@Autowired BurialScheduleDao burialScheduleDao;
	@Autowired CemeteryDao cemeteryDao;
	@Autowired UrlInformationDao urlDao;
 	
 	@RequestMapping(value="/QuerySchedule", method = RequestMethod.POST)
    public ModelAndView Home(HttpServletRequest request) {
    	String cemeteryId = request.getParameter("cemeteryId");
    	String lastName = request.getParameter("lastName");
    	String firstName = request.getParameter("firstName");
		ModelAndView model = null;
    	List<BurialScheduleV> schedule = null;
    	
    	if(cemeteryId != null && cemeteryId.equalsIgnoreCase("*")) {//All Cemeteries
    		if(lastName != null 
    				&& !lastName.equalsIgnoreCase("") 
    				&& firstName != null 
    				&& !firstName.equalsIgnoreCase("")) {//All Cemeteries, last & first name
    			schedule = burialScheduleDao.getBurialSchedule3(lastName.toUpperCase(), firstName.toUpperCase());
    		}else if (lastName != null 
    				&& !lastName.equalsIgnoreCase("")){//All cemeteries & last name
    			schedule = burialScheduleDao.getBurialSchedule4(lastName.toUpperCase());
    		}
    	} else {//Cemetery selected 
    		if (lastName != null 
    				&& !lastName.equalsIgnoreCase("") 
    				&& firstName != null 
    				&& !firstName.equalsIgnoreCase("")) { //Cemetery, last & first name selected
    			schedule = burialScheduleDao.getBurialSchedule1(cemeteryId, lastName.toUpperCase(), firstName.toUpperCase());
    		} else if (lastName != null 
    				&& !lastName.equalsIgnoreCase("")){//Cemetery & last name selected
    			schedule = burialScheduleDao.getBurialSchedule2(cemeteryId, lastName.toUpperCase());
    		} else {//Only Cemetery selected
    			
    			schedule = burialScheduleDao.getBurialScheduleFirst(cemeteryId);
    			if(schedule.size() > 0) {
    				// go to first result
            		model = new ModelAndView("schedule");
            		model.addObject("resultList", schedule);
            		CemeteryV c = cemeteryDao.getCemeteryByCemeteryId(cemeteryId);
            		model.addObject("cemetery", c);
            		model.addObject("url", urlDao.getUrlInformationByStationNum(new Integer(c.getManagingStationNum()).longValue(), c.getCemeteryType()));
            		SimpleDateFormat newDateFormat = new SimpleDateFormat("EEEE MMMM d, yyyy");            		
            		BurialScheduleV bs = schedule.get(0);            		
    				Date targetDate = bs.getScheduledDateTime();
            		model.addObject("targetDate", newDateFormat.format(targetDate));
            		SimpleDateFormat jsFormat = new SimpleDateFormat("yyyy,MM,dd");
            		model.addObject("jsDate", jsFormat.format(targetDate));	            		
            		return model;
    			}
    		}
    	} 	
    	
		if (schedule.size()== 0) { // No results return to search
			logger.debug("no results");
    		model = new ModelAndView("home");
    		model.addObject("noResults", "<p><b>No Results were found for your search.</b> Try refining your search.</p>");
    		model.addObject("firstName", firstName);
    		model.addObject("lastName", lastName);
    		model.addObject("cemeteryId", cemeteryId);
    		model.addObject("cemList", cemeteryDao.getAllCemeteries());
   		
    	} else if(schedule.size() == 1) { //1 result drill down for date & cemetery
    		BurialScheduleV bs = (BurialScheduleV)schedule.get(0);
    		model = new ModelAndView("schedule");
    		model.addObject("resultList", schedule);
    		CemeteryV c = cemeteryDao.getCemeteryByCemeteryId(bs.getCemeteryId());
    		model.addObject("cemetery", c);
    		model.addObject("url", urlDao.getUrlInformationByStationNum(new Integer(c.getNum()).longValue(), c.getCemeteryType()));
       		SimpleDateFormat newDateFormat = new SimpleDateFormat("EEEE MMMM d, yyyy");
    		model.addObject("targetDate", newDateFormat.format(bs.getScheduledDateTime()));
    		SimpleDateFormat jsFormat = new SimpleDateFormat("yyyy,MM,dd");
    		model.addObject("jsDate", jsFormat.format(bs.getScheduledDateTime()));

    	} else if(schedule.size() > 1) {//multiple results go to selection screen
    		model = new ModelAndView("home");
    		model.addObject("resultList", schedule);
    		model.addObject("firstName", firstName);
    		model.addObject("lastName", lastName);
    		model.addObject("cemList", cemeteryDao.getAllCemeteries());
    		model.addObject("cemeteryId", cemeteryId);
    	}
		return model;
    }
    
    @RequestMapping(value="/QS", method = RequestMethod.GET)
    public ModelAndView results(HttpServletRequest request) {
    	String cemeteryId = request.getParameter("cemId");
    	String targetDate = request.getParameter("tDate");
    	List<BurialScheduleV> schedule = null;

    	ModelAndView model = new ModelAndView("schedule");
    	if(cemeteryId != null 
    			&& !cemeteryId.equalsIgnoreCase("*")
    			&& targetDate != null
    			&& !targetDate.equalsIgnoreCase("")) 
    	{

    		SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        	Date txDate = null;;
    		try {
    			txDate = dateFormat.parse(targetDate);
    		} catch (ParseException e) {
    			e.printStackTrace();
    		}
        	schedule = burialScheduleDao.getBurialSchedule5(cemeteryId, txDate);
        		
        	if(schedule != null && schedule.size() > 0) {
            	model.addObject("resultList", schedule);   		
        		BurialScheduleV x = (BurialScheduleV)schedule.get(0);
        		model.addObject("url", x.getUrl());
        	} else {
        		model.addObject("noResults", "empty");
        	}
    		CemeteryV c = cemeteryDao.getCemeteryByCemeteryId(cemeteryId);
    		model.addObject("cemetery", c);
    		model.addObject("url", urlDao.getUrlInformationByStationNum(new Integer(c.getManagingStationNum()).longValue(), c.getCemeteryType()));
         	
       		SimpleDateFormat newDateFormat = new SimpleDateFormat("EEEE MMMM d, yyyy");
    		model.addObject("targetDate", newDateFormat.format(txDate));
    		SimpleDateFormat jsFormat = new SimpleDateFormat("yyyy,MM,dd");
    		model.addObject("jsDate", jsFormat.format(txDate));

    	}			
		return model;
    }

}