#!/bin/sh
# ###########################################################################
# Script generated by HP Fortify SCA Scan Wizard (c) HP Fortify 2011
# Created on 2014/04/16 09:30:48
# ###########################################################################
# Generated for the following languages:
# 	Java
# 	XML
# ###########################################################################
# DEBUG - if set to true, runs SCA in debug mode
# SOURCEANALYZER - the name of the SCA executable
# BUILDID - the SCA build id
# LAUNCHERSWITCHES - the launcher settings that are used to invoke SCA
# ARGFILE - the name of the argument file that's extracted and passed to SCA
# MEMORY - the memory settings for SCA
# OLDFILENUMBER - this defines the file which contains the number of files within the project, it is automatically generated
# FILENOMAXDIFF - this is the percentage of difference between the number of files which will trigger a warning by the script
# ###########################################################################

DEBUG=false
SOURCEANALYZER=sourceanalyzer
FPR="Fortifymission-health-resources.fpr"
BUILDID="mission-health-resources"
ARGFILE="Fortifymission-health-resources.sh.args"
MEMORY="-Xmx3200M -Xms2400M -Xss48M "
DEPENDENT_JARS="$HOME/.gradle/caches/**/*.jar"

LAUNCHERSWITCHES=""
OLDFILENUMBER=Fortifymission-health-resources.sh.fileno
FILENOMAXDIFF=10

# This script takes -h, -d, and -r options where the user can specify the project root directory and the gradle
# downloaded external dependencies file.
usage()
{
    echo "Usage:$0 options"
    echo "This script run with optional arguments."
    echo "OPTIONS:"
    echo "-d Dependent Jar files where gradle downloads on the local machine."
    echo " If not set, defaults to $HOME/.gradle/**/.jar"
    echo "-r Project Root directory from where fortity to be run."
    echo " If not set, defaults to $HOME/ihealthadapter/Product/Production"
}
DEPENDENT_JARS=
PROJECTROOT0=
while getopts “hd:r:” OPTION
    do
    case $OPTION in
    h)
        usage
        exit 1
    ;;
    d)
        DEPENDENT_JARS=$OPTARG
    ;;
    r)
        PROJECTROOT0=$OPTARG
    ;;
    esac
done
 
if [ -z $DEPENDENT_JARS ]; then
    DEPENDENT_JARS="$HOME/.gradle/caches/**/*.jar"
fi
if [ -z $PROJECTROOT0 ]; then
    PROJECTROOT0="$HOME/mission-health-resources";
fi

if [ $DEBUG = true ]; then export LAUNCHERSWITCHES="-debug $LAUNCHERSWITCHES"; fi
echo Extracting Arguments File


grep "# ARGS" $0 | grep -v grep | cut -d" " -f3- | sed -e s#PROJECTROOT0_MARKER#"$PROJECTROOT0"#g   > $ARGFILE

# ###########################################################################
echo Cleaning previous scan artifacts
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -clean 
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Translating files
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -cp $DEPENDENT_JARS:$JAVA_HOME/**/Classes/*.jar @$ARGFILE
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Testing Difference between Translations
FILENUMBER=`$SOURCEANALYZER -b $BUILDID -show-files | wc -l`

if [ ! -f $OLDFILENUMBER ]; then
	echo It appears to be the first time running this script, setting $OLDFILENUMBER to $FILENUMBER
	echo $FILENUMBER > $OLDFILENUMBER
else
	OLDFILENO=`cat $OLDFILENUMBER`
	DIFF=`expr $OLDFILENO "*" $FILENOMAXDIFF`
	DIFF=`expr $DIFF /  100`

	MAX=`expr $OLDFILENO + $DIFF`
	MIN=`expr $OLDFILENO - $DIFF`

	if [ $FILENUMBER -lt $MIN ] ; then SHOWWARNING=true; fi
	if [ $FILENUMBER -gt $MAX ] ; then SHOWWARNING=true; fi

	if [ $SHOWWARNING == true ] ; then
		echo "WARNING: The number of files has changed by over $FILENOMAXDIFF%, it is recommended"
		echo "         that this script is regenerated with the ScanWizard"
	fi

	echo $MAX $MIN $DIFF
fi;

# ###########################################################################
echo Starting scan
$SOURCEANALYZER $MEMORY $LAUNCHERSWITCHES -b $BUILDID -scan -f $FPR
if [ $? = 1 ] ; then
echo Sourceanalzyer failed, exiting
exit
fi
# ###########################################################################
echo Finished
# ARGS "-source"
# ARGS "1.6"
# ARGS -exclude "PROJECTROOT0_MARKER/build.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.git/logs/refs/heads/master"
# ARGS -exclude "PROJECTROOT0_MARKER/.git/logs/refs/remotes/origin/master"
# ARGS -exclude "PROJECTROOT0_MARKER/.git/refs/heads/master"
# ARGS -exclude "PROJECTROOT0_MARKER/.git/refs/remotes/origin/master"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-reports/com.agilex.vamf.missionhealth.restservice.html"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-reports/com.agilex.vamf.missionhealth.restservice.MissionHealthResourcePerfTest.html"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-reports/com.agilex.vamf.missionhealth.restservice.MissionHealthResourceTest.html"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-reports/index.html"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/contiperf-report/index.html"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/reports/tests/index.html"
# ARGS -exclude "PROJECTROOT0_MARKER/.gradle/1.6/taskArtifacts/cache.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/gradle/wrapper/gradle-wrapper.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/gradle.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/resources/intTest/log4j.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/resources/intTest/spring/properties/inttest.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/AuthenticationInfo.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/AuthorizationResult.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/HTTPOAuthFilter.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/JerseyClientHandle.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/JerseyFactory.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/MobileHealthClientTestVersion.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/ModeHelper.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/clientapi/OauthClient.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/restservice/MissionHealthResourcePerfTest.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/restservice/MissionHealthResourceTest.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/testutility/IntegrationTestConfiguration.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/testutility/NullCheckerAssert.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/testutility/PatientLoader.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/testutility/TestHelper.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/java/com/agilex/vamf/missionhealth/testutility/XpathHelper.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/resources/log4j.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/resources/spring/properties/inttest.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/log4j.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/META-INF/cocoon/properties/missionhealth.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/META-INF/cocoon/properties/va-veteran-dev.properties"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/src/inttest/java/com/agilex/vamf/missionhealth/datalayer/MissionHealthDataLayerImplTest.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/src/inttest/java/com/agilex/vamf/missionhealth/datalayer/MissionHealthDataServiceTest.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/src/inttest/java/com/agilex/vamf/missionhealth/datalayer/MissionHealthTaskServiceTest.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/src/inttest/java/com/agilex/vamf/missionhealth/datalayer/SpringBasedIntegrationRepo.java"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-reports/report.js"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/reports/tests/report.js"
# ARGS -exclude "PROJECTROOT0_MARKER/.git/config"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/artifacts/Gradle___com_agilex_healthcare_MissionHealthServiceWeb___MissionHealthServiceWeb_1_0_SNAPSHOT_war.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/artifacts/Gradle___com_agilex_healthcare_MissionHealthServiceWeb___MissionHealthServiceWeb_1_0_SNAPSHOT_war__exploded_.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/compiler.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/copyright/profiles_settings.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/encodings.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/gradle.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__activation_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__antlr_2_7_6.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__aopalliance_1_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__asm_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__aspectjrt_1_6_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__aspectjweaver_1_6_10.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__AuthorizationServicesLib_0_1_0_SNAPSHOT.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__AuthorizationServicesLib_4_1_0_SNAPSHOT.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__backport_util_concurrent_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__BeanstalkClient_1_4_6.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__BeanStalkProvider_0_8.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__cglib_2_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__cglib_nodep_2_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__cocoon_configuration_api_1_0_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__cocoon_spring_configurator_2_1_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_beanutils_1_8_3.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_codec_1_5.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_codec_1_7.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_collections_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_collections_3_2_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_io_2_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_io_2_4.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_lang3_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_lang_2_6.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_logging_1_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_math_1_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__commons_pool_1_5_4.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__contiperf_2_0_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__cssparser_0_9_9.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__dom4j_1_6_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__geronimo_activation_1_1_spec_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__geronimo_javamail_1_4_spec_1_7_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__guava_13_0_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hamcrest_core_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__HealthAdapterLib_0_1_0_SNAPSHOT.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__HealthAdapterMessagingAPI_0_8.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hibernate_annotations_3_5_6_Final.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hibernate_commons_annotations_3_2_0_Final.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hibernate_core_3_5_6_Final.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hibernate_entitymanager_3_5_6_Final.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__hibernate_jpa_2_0_api_1_0_0_Final.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__htmlunit_2_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__htmlunit_core_js_2_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__httpclient_4_2_3.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__httpcore_4_2_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__httpmime_4_2_3.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__ical4j_1_1_SNAPSHOT.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jackson_core_asl_1_9_5.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jackson_jaxrs_1_9_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jackson_mapper_asl_1_9_5.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jackson_xc_1_9_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__javassist_3_9_0_GA.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jaxb_api_2_2_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jaxb_impl_2_2_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jcl_over_slf4j_1_6_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jdom_1_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_client_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_core_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_json_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_server_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_servlet_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jersey_spring_1_12.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jettison_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jetty_http_8_1_9_v20130131.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jetty_io_8_1_9_v20130131.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jetty_util_8_1_9_v20130131.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jetty_websocket_8_1_9_v20130131.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__joda_time_1_6_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jsonij_0_2_11.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jsp_api_2_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jsr311_api_1_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jta_1_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__jtds_1_2_8.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__junit_4_8_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__junit_dep_4_10.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__log4j_1_2_16.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__logback_classic_1_0_7.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__logback_core_1_0_7.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__mail_1_4_6.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__metrics_core_2_2_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__MHPClientUtils_0_1_0_SNAPSHOT.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__mongo_java_driver_2_10_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__nekohtml_1_9_18.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__ojdbc6_11_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__org_apache_servicemix_bundles_commons_dbcp_1_4_3.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__rome_0_9.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__sac_1_3.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__serializer_2_7_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__servlet_api_2_5.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__slf4j_api_1_6_6.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__slf4j_api_1_7_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__slf4j_log4j12_1_6_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_aop_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_asm_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_beans_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_context_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_context_support_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_core_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_expression_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_jdbc_3_1_1_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_orm_3_1_1_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_acl_3_1_0_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_config_3_1_3_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_core_3_1_3_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_oauth2_1_0_4_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_taglibs_3_1_0_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_security_web_3_1_3_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_test_3_1_1_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_tx_3_1_1_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_web_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__spring_webmvc_3_1_2_RELEASE.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__stax_api_1_0_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__stax_api_1_0_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xalan_2_7_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xercesImpl_2_10_0.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xercesImpl_2_9_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xml_apis_1_3_04.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xml_apis_1_4_01.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xmlpull_1_1_3_1.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xpp3_min_1_1_4c.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/libraries/Gradle__xstream_1_4_2.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/misc.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/modules.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/scopes/scope_settings.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/vcs.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/.idea/workspace.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/cucumber/properties.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/cucumber/targets.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/enunciate/enunciate.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/enunciate/properties.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/enunciate/targets.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/tomcat/properties.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/tomcat/targets.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/weblogic/properties.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/ant-builds/weblogic/targets.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-results/TEST-com.agilex.vamf.missionhealth.restservice.MissionHealthResourcePerfTest.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/inttest-results/TEST-com.agilex.vamf.missionhealth.restservice.MissionHealthResourceTest.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/build/resources/intTest/integrationApplicationContext.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthResourceIntTest/src/inttest/resources/integrationApplicationContext.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/applicationContext.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/META-INF/cocoon/spring/missionhealthService-security.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/META-INF/cocoon/spring/va-veteran-dev/applicationContext-JPA.xml"
# ARGS -exclude "PROJECTROOT0_MARKER/MissionHealthServiceWeb/build/resources/main/META-INF/cocoon/spring/va-veteran-prod/applicationContext-JPA.xml"
# ARGS "PROJECTROOT0_MARKER"
