package com.agilex.vamf.utils;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * Created by guthriev on 4/17/14.
 */
public class XSSSafeStringMarshaller extends XmlAdapter<String, String> {

    @Override
    public String unmarshal(String s) throws Exception {
        String encoded = null;
        if(null!=s){
            Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
            encoded = Jsoup.clean(s, "", Whitelist.basic(), outputSettings);
        }
        return encoded;
    }

    @Override
    public String marshal(String s) throws Exception {
        String encoded = null;
        if(null!=s){
            Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);
            encoded = Jsoup.clean(s, "", Whitelist.basic(), outputSettings);
        }
        return encoded;
    }
}
