package com.agilex.vamf.utils;

import java.util.Collection;

import com.agilex.healthcare.utility.NullChecker;

public class StringUtil {

    public static boolean isEmpty(String s) {
        if ((s == null) || s.length()==0)
            return true;
        return false;
    }
    
	public static String objectToString(Object object) {
		String result = null;
		
		if (object != null) {
			result = object.toString();
		}
		
		return result;
	}
    
    public static String blankIfNull(String str) {
    	return str==null ? "" : str;
    }
    
    public static String blankIfNull(Integer integer) {
    	return integer==null ? "" : integer.toString();
    }
    
	public static String toLowerCaseIgnoreNull(String value) {
		String result = null;
		if (value != null) {
			result = value.toLowerCase();
		}
		return result;
	}

	public static String toUpperCaseIgnoreNull(String value) {
		String result = null;
		if (value != null) {
			result = value.toUpperCase();
		}
		return result;
	}

    public static boolean matchIgnoreCase(String strA, String strB) {
    	if (strA==null || strB==null)
    		return false;
    	return strA.equalsIgnoreCase(strB);
    }

    public static boolean matchIgnoreCaseAcceptNull(String strA, String strB) {
    	if (strA==null && strB==null)
    		return true;
    	if (strA != null && strB != null)
        	return strA.equalsIgnoreCase(strB);
    	return false;
    }
    
    public static boolean contentEqualsAcceptNull(Collection<String> listA, Collection<String> listB) {
    	if (NullChecker.isNullish(listA) && NullChecker.isNullish(listB))
    		return true;
    	if (listA.size() != listB.size())
    		return false;
    	return listA.containsAll(listB);
    }
    
    public static boolean startsWithIgnoreCase(String prefix, String term) {
    	boolean result = false;
    	if (NullChecker.isNullish(term) || NullChecker.isNullish(prefix)) {
    		return result;
    	}
    	
    	int prefixLength = prefix.length();
    	
    	String beginningString = term;
    	if (prefixLength <= term.length()) {
    		beginningString = term.substring(0, prefixLength);
    		result = prefix.equalsIgnoreCase(beginningString);
    	}
    	
    	return result;
    }
    
    
    public static String concatIgnoreNull(String separator, String... strs) {
    	StringBuilder sb = new StringBuilder();
    	boolean first = true;
    	for (String str : strs) {
    		if (!isEmpty(str)) {
    			if (!first)
    				sb.append(separator);
    			first = false;
    			sb.append(str);
    		}
    	}
    	return sb.toString();
    }
    
    public static String concatWithDesc(String label, String desc) {
    	StringBuilder sb = new StringBuilder();
    	if (!isEmpty(label)) {
    		sb.append(label);
    	}
    	if (!isEmpty(desc)) {
    		sb.append(" (");
    		sb.append(desc);
    		sb.append(")");
    	}
       	return sb.toString();
    }
}
