package com.agilex.vamf.utils;

import java.util.Iterator;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextManager implements NamespaceContext {
	@Override
	public String getNamespaceURI(String prefix) {
		if (prefix.equals("mh"))
			return "http://healthcare.agilex.com/missionhealth";
		else if (prefix.equals("m"))
			return "http://healthcare.agilex.com/mobilehealthplatform";
		else if (prefix.equals("atom"))
			return "http://www.w3.org/2005/Atom";
		else if (prefix.equals("log4j"))
			return "http://jakarta.apache.org/log4j/";
		else
			return XMLConstants.NULL_NS_URI;
	}
 
	@Override
	public String getPrefix(String namespace) {
		if (namespace.equals("http://healthcare.agilex.com/missionhealth"))
			return "mh";
		if (namespace.equals("http://healthcare.agilex.com/mobilehealthplatform"))
			return "m";
		else if (namespace.equals("http://www.w3.org/2005/Atom"))
			return "atom";
		else if (namespace.equals("http://jakarta.apache.org/log4j/"))
			return "log4j";
		else
			return null;
	}

	@Override
	public Iterator<String> getPrefixes(String namespace) {
		return null;
	}
}
