package com.agilex.vamf.utils;

import com.agilex.vamf.missionhealth.domain.DOBDate;

import javax.xml.bind.annotation.adapters.XmlAdapter;


public class DOBDateMarshaller extends XmlAdapter<String, DOBDate> {

	private static final String DATE_FORMAT = "MMM dd, yyyy";

	@Override
	public String marshal(DOBDate date) throws Exception {
		if (date != null){
	        return date.toString();
		}else{
			return null;
		}
	}

	@Override
	public DOBDate unmarshal(String dateStr) throws Exception {
		if (NullChecker.isNotNullish(dateStr)){
			return new DOBDate(DATE_FORMAT, dateStr);
		}else{
			return null;
		}
			
		
	}

}
