package com.agilex.vamf.missionhealth.uri;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import com.agilex.vamf.missionhealth.domain.MissionHealthProfile;

public class MissionHealthLinkBuilder {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(MissionHealthLinkBuilder.class);

	private URI baseUri;

	public MissionHealthLinkBuilder(URI baseUri) {
		this.baseUri = baseUri;
	}

	public URI createMissionHealthSelfUri(String assigningAuthority, String patientId, String missionProfileId) {
		URI retValue = UriBuilder.fromUri(this.baseUri).path("patient").path(assigningAuthority).path(patientId).path("mission-health").path("id").path(missionProfileId).build();
		if (LOGGER.isDebugEnabled())
			LOGGER.debug(retValue.toString());
		return retValue;
	}
	
	public void fillLinks(MissionHealthProfile missionHealthProfile) {
		MissionHealthLinkBuilder linkBuilder = new MissionHealthLinkBuilder(baseUri);
		missionHealthProfile.setSelfUri(linkBuilder.createMissionHealthSelfUri(missionHealthProfile.getPatientIdentifier().getAssigningAuthority(), missionHealthProfile.getPatientIdentifier().getUniqueId(), missionHealthProfile.getId()));
	}

}