package com.agilex.vamf.missionhealth.service;

import com.agilex.vamf.missionhealth.domain.MissionReadinessReport;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: vguthrie
 * Date: 11/15/13
 * Time: 11:02 AM
 */
public class WeeklyUserMetrics {

    private String patientId;
    private Date createDatetime;
    private Integer daysWithLoginForCycle = 0;
    private List<MissionReadinessReport> missionReadinessReportList = new ArrayList<MissionReadinessReport>();

    public WeeklyUserMetrics() {
    }

    public WeeklyUserMetrics(String patientId, Date createDatetime) {
        this.patientId = patientId;
        this.createDatetime = createDatetime;
    }

    public String getPatientId() {
        return patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public List<MissionReadinessReport> getMissionReadinessReportList() {
        return missionReadinessReportList;
    }

    public void setMissionReadinessReportList(List<MissionReadinessReport> missionReadinessReportList) {
        this.missionReadinessReportList = missionReadinessReportList;
    }

    public Integer getDaysWithLoginForCycle() {
        return daysWithLoginForCycle;
    }

    public void setDaysWithLoginForCycle(Integer daysWithLoginForCycle) {
        this.daysWithLoginForCycle = daysWithLoginForCycle;
    }

    public Date getCreateDatetime() {
        return createDatetime;
    }

    public void setCreateDatetime(Date createDatetime) {
        this.createDatetime = createDatetime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WeeklyUserMetrics)) return false;

        WeeklyUserMetrics that = (WeeklyUserMetrics) o;

        if (!patientId.equals(that.patientId)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return patientId.hashCode();
    }
}
