package com.agilex.vamf.missionhealth.service;

import com.agilex.vamf.utils.DateHelper;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: vguthrie
 * Date: 12/16/13
 * Time: 5:03 PM
 */
public class MissionHealthTimeFrameService {

    public static Map<String,Calendar> getMissionYearTimeFrame(Date today){
        Map<String,Calendar> dates=new HashMap<String,Calendar>();
        Calendar beginningOfWeek= GregorianCalendar.getInstance();
        if(beginningOfWeek.get(Calendar.DAY_OF_WEEK)==1){
            beginningOfWeek.add(Calendar.DATE, -1);
            beginningOfWeek.set(Calendar.DAY_OF_WEEK,-5);
        }
        else{
            beginningOfWeek.set(Calendar.DAY_OF_WEEK,2);
        }
        dates.put("beginningOfWeek",beginningOfWeek);

        Calendar  calendar=GregorianCalendar.getInstance();
        calendar.set(calendar.get(Calendar.YEAR), 4, 1);
        calendar.set(Calendar.DAY_OF_WEEK_IN_MONTH,3);
        calendar.add(Calendar.DAY_OF_WEEK,7-calendar.get(Calendar.DAY_OF_WEEK));
        calendar.add(Calendar.DATE,2);
        //previous year
        if(today.before(calendar.getTime())){
            calendar.add(Calendar.DATE,-1);
            dates.put("endDate", calendar);
            Calendar startDate=GregorianCalendar.getInstance();
            startDate.set(startDate.get(Calendar.YEAR)-1,4, 1);
            startDate.set(Calendar.DAY_OF_WEEK_IN_MONTH,startDate.get(Calendar.DAY_OF_WEEK_IN_MONTH)+2);
            startDate.add(Calendar.DAY_OF_WEEK,7-startDate.get(Calendar.DAY_OF_WEEK));
            startDate.add(Calendar.DATE,2);
            dates.put("startDate", startDate);
            return dates;
        }//current year
        else{
            dates.put("startDate", calendar);
            Calendar endDate=GregorianCalendar.getInstance();
            endDate.set(endDate.get(Calendar.YEAR)+1,4, 1);
            endDate.set(Calendar.DAY_OF_WEEK_IN_MONTH,endDate.get(Calendar.DAY_OF_WEEK_IN_MONTH)+2);
            endDate.add(Calendar.DAY_OF_WEEK,7-endDate.get(Calendar.DAY_OF_WEEK));
            endDate.add(Calendar.DATE,1);
            dates.put("endDate", endDate);
            return dates;
        }
    }
}
