package com.agilex.vamf.missionhealth.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: vguthrie
 * Date: 12/12/13
 * Time: 11:45 AM
 */
public abstract class AbstractMissionHealthStatus {

    public static String READY = "READY";
    public static String PROCESSING = "PROCESSING";
    public static String SUCCESS = "SUCCESS";
    public static String FAILED = "FAILED";

    private String id;
    private Date createDatetime = new Date();
    private Date startDatetime = new Date();
    private Date completeDatetime;
    private boolean complete = false;
    private String status;
    private List<String> errors = new ArrayList<String>();

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreateDatetime() {
        return createDatetime;
    }

    public void setCreateDatetime(Date createDatetime) {
        this.createDatetime = createDatetime;
    }

    public Date getStartDatetime() {
        return startDatetime;
    }

    public void setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
    }

    public boolean isComplete() {
        return complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public List<String> getErrors() {
        return errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCompleteDatetime() {
        return completeDatetime;
    }

    public void setCompleteDatetime(Date completeDatetime) {
        this.completeDatetime = completeDatetime;
    }
}
