package com.agilex.vamf.missionhealth.resource;

import java.net.URI;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.agilex.vamf.missionhealth.domain.ResourceDirectory;
import com.agilex.vamf.missionhealth.uri.ResourceDirectoryBuilder;
import com.agilex.vamf.utils.PropertyHelper;


@Path("/public/resource-directory")
@Component
@Scope("request")
public class ResourceDirectoryResource {

	@Resource
	ResourceDirectoryBuilder resourceDirectoryBuilder;
	
	@Resource
    private PropertyHelper propertyHelper;

	/**
	 * This resource returns a list of the "root" resources in the system. This
	 * resource should be the only thing known to client applications - every
	 * other resource should be discovered.
	 * 
	 * Support formats include:<br>
	 * application/atom+xml<br>
	 * application/xml<br>
	 * application/json
	 * 
	 * @return resource-directory containing each of the system resources
	 */
	@GET
	@Produces({ "application/atom+xml", "application/json", "application/xml" })
	public ResourceDirectory fetchResourceDirectory(@QueryParam("assigning-authority") String assigningAuthority, 
													@QueryParam("patient-id") String patientId, 
													@Context UriInfo u, 
			  										@Context HttpHeaders headers) {
		URI mhpUri = UriBuilder.fromUri(propertyHelper.getProperty("mhp.baseUri")).build();
		ResourceDirectory resourceDirectory = resourceDirectoryBuilder.getResourceDirectory(u.getBaseUri(), u.getRequestUri(), mhpUri, assigningAuthority, patientId);
		return resourceDirectory;
	}

}
