package com.agilex.vamf.missionhealth.resource;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.security.MhpUserFactory;
import com.agilex.vamf.missionhealth.domain.MissionHealthUser;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

/**
 * Created by guthriev on 1/21/14.
 */
@Component
@Scope("request")
@Path("mhpuser")
public class MissionHealthUserResource {

    /**
     * Returns an object representing the currently authenticated user of the mission health application.
     *
     * @param uriInfo
     * @param request
     * @param headers
     * @return MissionHealthUser
     */
    @GET
    @Produces({ "application/xml", "application/json" })
    public MissionHealthUser getMissionHealthUser(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context HttpHeaders headers){
        com.agilex.healthcare.mobilehealthplatform.domain.MhpUser mhpUser = MhpUserFactory.createFromSecurityContext();
        return new MissionHealthUser(mhpUser);
    }
}
