package com.agilex.vamf.missionhealth.resource;

import java.net.URI;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ExceptionFactory {
	public static WebApplicationException generateApplicationException(Throwable t) {
		throw new WebApplicationException(t, Response.Status.INTERNAL_SERVER_ERROR);
	}

	public static WebApplicationException generateNoDataFoundException() {
		throw new WebApplicationException(Response.Status.NOT_FOUND);
	}

	public static WebApplicationException generateNoDataFoundException(URI notFoundUri, Class<?> type) {
		String message = String.format("Unable to fetch item of type %s", type);
		throw new com.sun.jersey.api.NotFoundException(message, notFoundUri);
	}

	public static WebApplicationException generateHealthCheckException() {
		throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
	}

	public static WebApplicationException generateUnauthorizeException() {
		throw new WebApplicationException(Response.Status.UNAUTHORIZED);
	}

	public static WebApplicationException generateRedirect(URI redirectUri) {
		Response response = Response.temporaryRedirect(redirectUri).build();
		throw new WebApplicationException(response);
	}

	public static WebApplicationException generatedBadRequestException() {
		throw new WebApplicationException(Response.Status.BAD_REQUEST);
	}

}
