package com.agilex.vamf.missionhealth.message;

import com.agilex.messaging.provider.beanstalk.Queue;
import com.agilex.messaging.provider.beanstalk.config.BeanstalkBusConfiguration;

public class HaMessagingConfiguration extends BeanstalkBusConfiguration {

    private final boolean enabled;
    private String queueName;

    public HaMessagingConfiguration(String host, int port, boolean enabled, String queueName, int priority,
                                    int delaySecond, int processExpirationSecond, int maxRetries, int retryDelaySecond,
                                    Integer replyTimeoutSecond) {
        super(host, port);
        this.enabled = enabled;
        this.setQueueName(queueName);
        super.addQueueConfiguration(Queue.createDestination(queueName), priority, delaySecond, processExpirationSecond,
                maxRetries, retryDelaySecond, replyTimeoutSecond);
    }

    public HaMessagingConfiguration(String host, int port, boolean enabled, String queueName) {
        super(host, port);
        this.enabled = enabled;
        this.setQueueName(queueName);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public String getQueueName() {
        return queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }
}