package com.agilex.vamf.missionhealth.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailNotificationPublisher extends EmailMessagePublisher {
    private final static Log logger = LogFactory.getLog(EmailNotificationPublisher.class);

    public EmailNotificationPublisher(HaMessagingConfiguration configuration) {
        super(configuration, configuration.getQueueName());
    }

    public void send(EmailNotificationMessage message) {
        logger.debug(message.getClass().getName() + " Received");

        publishMessage(message, configuration.getQueueName());
    }
}

