package com.agilex.vamf.missionhealth.message;

import java.io.Serializable;
import java.util.UUID;

import com.agilex.messaging.core.Message;

@SuppressWarnings("serial")
public class EmailNotificationMessage implements Message, Serializable {

    private String emailAddress;
    private final String messageId;
    private EmailDefaults emailDefaults;

    public EmailNotificationMessage(String emailAddress, EmailDefaults emailDefaults) {
        this.emailDefaults = emailDefaults;
        this.messageId = UUID.randomUUID().toString();
        this.emailAddress = emailAddress;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    @Override
    public String id() {
        return messageId;
    }

    public String getMessageBody() {
        return emailDefaults.getBody();
    }

    public String getToAddress() {
        return emailDefaults.getToAddress();
    }

    public String getFromAddress() {
        return emailDefaults.getReplyToAddress();
    }

    public String getSubject() {
        return emailDefaults.getSubject();
    }
}

