package com.agilex.vamf.missionhealth.domain.enumeration;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

import com.agilex.vamf.utils.NullChecker;

@XmlType(name = "status")
@XmlEnum
public enum MissionStatus {
    /** the mission is in-progess (part of the current mission cycle) */
	@XmlEnumValue("ACTIVE")
	ACTIVE("ACTIVE"),
    /**  the mission was completed successfully (i.e. the user either completed 100% of the mission or reached the required threshold at the end of a mission cycle) */
	@XmlEnumValue("COMPLETE")
	COMPLETE("COMPLETE"),
    /** the user did not reached the required threshold at the end of a mission cycle */
	@XmlEnumValue("ATTEMPTED")
    ATTEMPTED("ATTEMPTED"),
    /** The mission has no current status */
	@XmlEnumValue("NONE")
	NONE("NONE");
	private String name;
	
	private MissionStatus(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}
	
	public static MissionStatus fromValue(String value) {
		if (NullChecker.isNullish(value))
			return MissionStatus.NONE;
		
		for (MissionStatus is : MissionStatus.values()) {
			if (is.name.equals(value))
				return is;
		}
		throw new IllegalArgumentException(value);
	}	
}
