package com.agilex.vamf.missionhealth.domain.comparator;

import com.agilex.vamf.missionhealth.domain.MissionHealthStanding;

import java.util.Comparator;

/**
 * Created with IntelliJ IDEA.
 * User: vguthrie
 * Date: 12/4/13
 * Time: 4:38 PM
 */
public class MissionHealthStandingComparator implements Comparator<MissionHealthStanding> {

    @Override
    public int compare(MissionHealthStanding thisStanding, MissionHealthStanding otherStanding) {
        // scoreboard sort:
        // 1) points DESC
        // 2) troops DESC
        // 3) level DESC
        // 4) name ASC

        if(otherStanding.getPoints().compareTo(thisStanding.getPoints()) == 0){
            if(otherStanding.getTroops().compareTo(thisStanding.getTroops()) == 0){
                if(otherStanding.getLevel().compareTo(thisStanding.getLevel()) == 0){
                    return thisStanding.getName().compareTo(otherStanding.getName());
                } else {
                    return otherStanding.getLevel().compareTo(thisStanding.getLevel());
                }
            } else {
                return otherStanding.getTroops().compareTo(thisStanding.getTroops());
            }
        } else {
            return otherStanding.getPoints().compareTo(thisStanding.getPoints());
        }

    }
}
