package com.agilex.vamf.missionhealth.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * Metrics aggregated by service at the end of each mission cycle
 */
@XmlRootElement(name = "weeklyservicemetrics", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class WeeklyServiceMetrics {

    /** The service branch for this data */
    @XmlElement
    private String service;

    /** The total users registered to this service */
    @XmlElement
    private Integer totalUsers = 0;

    /** The total active users registered to this service */
    @XmlElement
    private Integer activeUsers = 0;

    /** The number of mission completed by this service */
    @XmlElement
    private Integer totalMissionsCompleted = 0;

    /** The total points earned by this service */
    @XmlElement
    private Integer totalPoints = 0;

    /** The total troops assigned to this service */
    @XmlElement
    private Integer totalTroops=0;

    /** used to break ties between multiple services with the same points, troops, etc */
    @XmlElement
    private Integer winner=0;

    /** The data for the annual service metrics graph */
    @XmlElement
    private List<Integer> graph=new ArrayList<Integer>();
    
    public WeeklyServiceMetrics() {
    }

    public WeeklyServiceMetrics(String service) {
        this.service = service;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Integer getTotalUsers() {
        return totalUsers;
    }

    public void setTotalUsers(Integer totalUsers) {
        this.totalUsers = totalUsers;
    }

    public Integer getActiveUsers() {
        return activeUsers;
    }

    public void setActiveUsers(Integer activeUsers) {
        this.activeUsers = activeUsers;
    }

    public Integer getTotalMissionsCompleted() {
        return totalMissionsCompleted;
    }

    public void setTotalMissionsCompleted(Integer totalMissionsCompleted) {
        this.totalMissionsCompleted = totalMissionsCompleted;
    }

    public Integer getTotalPoints() {
        return totalPoints;
    }

    public void setTotalPoints(Integer totalPoints) {
        this.totalPoints = totalPoints;
    }

    public Integer getTotalTroops() {
		return totalTroops;
	}

	public void setTotalTroops(Integer totalTroops) {
		this.totalTroops = totalTroops;
	}

	public Integer getWinner() {
		return winner;
	}

	public void setWinner(Integer winner) {
		this.winner = winner;
	}

	public List<Integer> getGraph() {
		return graph;
	}

	public void setGraph(List<Integer> graph) {
		this.graph = graph;
	}

	@Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WeeklyServiceMetrics)) return false;

        WeeklyServiceMetrics that = (WeeklyServiceMetrics) o;

        if (!service.equals(that.service)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return service.hashCode();
    }
}
