package com.agilex.vamf.missionhealth.domain;

/**
 * This enum represents the branches of service eligible to participate in the mission health game
 */
public enum Service {
	/*
	 * Do not change below order. Below order determines order of existence of each service
	 */
	ARMY("Army"), 
	MARINES("Marines"),
	NAVY("Navy"), 
    AIRFORCE("Air Force"),
    COASTGAURD("Coast Guard"); 
    
    private String service;
    
	private Service(String service) {
		this.service = service;
	}
 
	public String getService() {
		return service;
	}
	
	public static Service fromString(String text) {
	    if (text != null) {
	      for (Service service : Service.values()) {
	        if (text.equalsIgnoreCase(service.getService())) {
	          return service;
	        }
	      }
	    }
	    throw new IllegalArgumentException("Invalid service name provided");
	  }    
}