package com.agilex.vamf.missionhealth.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.vamf.utils.DOBDateMarshaller;
import com.agilex.vamf.utils.DateTimeMarshaller;
import com.agilex.vamf.utils.NullChecker;


/**
 * 
 * @author j.ray
 */
@XmlRootElement(name = "patient", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Patient extends DomainTransferObject implements Comparable<Patient> {

	private static final long serialVersionUID = 1L;
	
	private String displayName = null;
	@XmlElement
	private String firstName;
	@XmlElement
	private String lastName;
	@XmlElement
	private String middleName;
	@XmlElement
	@XmlJavaTypeAdapter(DOBDateMarshaller.class)
	private DOBDate dateOfBirth;
	@XmlElement
	private String gender;
	@XmlElement(namespace = Namespace.MissionHealth)
	private PatientIdentifier patientIdentifier = new PatientIdentifier();
	@XmlElement
	private String ssn;
	@XmlElement
	private String middleInitial;
	@XmlElement
	private String age = null;
	@XmlElement
	private String wardLocation = null;
	@XmlElement
    private String locationIEN;
    @XmlElement
    private String icn;
    @XmlElement
    private boolean serviceConnected;
    @XmlElement
    private String serviceConnectedPercent;
    @XmlElement
    private boolean sensitive;
    @XmlElement
    @XmlJavaTypeAdapter(DateTimeMarshaller.class)
    private Date admittedDateTime;

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getSsn() {
		return this.ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public DOBDate getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(DOBDate dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setId(String id) {
		getPatientIdentifier().setUniqueId(id);
	}

	public String getWardLocation() {
		return wardLocation;
	}

	public void setWardLocation(String wardLocation) {
		this.wardLocation = wardLocation;
	}

	public void setMiddleInitial(String middleInitial) {
		this.middleInitial = middleInitial;
	}

	public String getMiddleInitial() {
		return middleInitial;
	}

	public void setAge(String age) {
		this.age = age;
	}

	public String getAge() {
		return age;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	@XmlElement
	public String getDisplayName() {
		if(NullChecker.isNullish(displayName)){
			displayName = lastName + ", " + firstName;
		}
		return displayName;
	}

	@Override
	public int compareTo(Patient patient) {
		PatientSortingAlgorithm algorithm = new PatientSortingAlgorithm();
		return algorithm.compare(this, patient);
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public PatientIdentifier getPatientIdentifier() {
		if (patientIdentifier == null)
			patientIdentifier = new PatientIdentifier();
		return patientIdentifier;
	}

	public static String serializePatientIdentifier(Patient patient) {
		String s = null;
		if (!(patient == null))
			s = patient.getPatientIdentifier().toString();
		return s;
	}

    public String getLocationIEN() {
        return locationIEN;
    }

    public void setLocationIEN(String locationIEN) {
        this.locationIEN = locationIEN;
    }

    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public boolean isServiceConnected() {
        return serviceConnected;
    }

    public void setServiceConnected(boolean serviceConnected) {
        this.serviceConnected = serviceConnected;
    }

    public String getServiceConnectedPercent() {
        return serviceConnectedPercent;
    }

    public void setServiceConnectedPercent(String serviceConnectedPercent) {
        this.serviceConnectedPercent = serviceConnectedPercent;
    }

    public boolean isSensitive() {
        return sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public Date getAdmittedDateTime() {
        return admittedDateTime;
    }

    public void setAdmittedDateTime(Date admittedDateTime) {
        this.admittedDateTime = admittedDateTime;
    }
}