package com.agilex.vamf.missionhealth.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents the user's responses to the mission readiness survey
 */
@XmlRootElement(name = "missionreadinessreport", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MissionReadinessReport extends DomainTransferObject {

	private static final long serialVersionUID = 1879790714635598053L;
	
	@XmlElement
	private String id;
	
	@XmlElement
	private Integer health=0;
	
	@XmlElement
	private Integer physical=0;
	
	@XmlElement
	private Integer emotional=0;
	
	@XmlElement
	private Date insDate;
	
	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public Integer getHealth() {
		return health;
	}


	public void setHealth(Integer health) {
		this.health = health;
	}


	public Integer getPhysical() {
		return physical;
	}


	public void setPhysical(Integer physical) {
		this.physical = physical;
	}


	public Integer getEmotional() {
		return emotional;
	}


	public void setEmotional(Integer emotional) {
		this.emotional = emotional;
	}


	public Date getInsDate() {
		return insDate;
	}


	public void setInsDate(Date insDate) {
		this.insDate = insDate;
	}


	@Override
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}
	
}
