package com.agilex.vamf.missionhealth.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;

import javax.xml.bind.annotation.*;

/**
 * Represents a user of the mission health application
 */
@XmlRootElement(name = "missionHealthUser", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MissionHealthUser extends DomainTransferObject {

    @XmlElement
    protected String lastName;
    @XmlElement
    protected String firstName;
    @XmlElement
    protected String middleInitials;
    @XmlElement
    private String displayName;
    @XmlElement
    private String title;
    @XmlTransient
    private String accessCode;
    @XmlElement
    private Boolean rightOfAccessAccepted = null;
    @XmlElement
    private Boolean staffUserDisclaimerAccepted = null;
    @XmlElement
    private String vistaLocation;
    @XmlElement
    private String facilityName;
    @XmlElement
    private String userName;
    @XmlElement
    private PatientIdentifier userIdentifier = new PatientIdentifier();

    public MissionHealthUser(){}

    public MissionHealthUser(MhpUser mhpUser){
        this.lastName = mhpUser.getLastName();
        this.firstName = mhpUser.getFirstName();
        this.middleInitials = mhpUser.getMiddleInitials();
        this.displayName = mhpUser.getDisplayName();
        this.title = mhpUser.getTitle();
        this.accessCode = mhpUser.getAccessCode();
        this.rightOfAccessAccepted = mhpUser.isStaffUserDisclaimerAccepted();
        this.staffUserDisclaimerAccepted = mhpUser.isStaffUserDisclaimerAccepted();
        this.vistaLocation = mhpUser.getVistaLocation();
        this.facilityName = mhpUser.getFacilityName();
        this.userName = mhpUser.getUserName();
        if(null!=mhpUser.getUserIdentifier()){
            this.userIdentifier = new PatientIdentifier(
                    mhpUser.getUserIdentifier().getAssigningAuthority(),
                    mhpUser.getUserIdentifier().getUniqueId());
        }
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleInitials() {
        return middleInitials;
    }

    public void setMiddleInitials(String middleInitials) {
        this.middleInitials = middleInitials;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAccessCode() {
        return accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public Boolean getRightOfAccessAccepted() {
        return rightOfAccessAccepted;
    }

    public void setRightOfAccessAccepted(Boolean rightOfAccessAccepted) {
        this.rightOfAccessAccepted = rightOfAccessAccepted;
    }

    public Boolean getStaffUserDisclaimerAccepted() {
        return staffUserDisclaimerAccepted;
    }

    public void setStaffUserDisclaimerAccepted(Boolean staffUserDisclaimerAccepted) {
        this.staffUserDisclaimerAccepted = staffUserDisclaimerAccepted;
    }

    public String getVistaLocation() {
        return vistaLocation;
    }

    public void setVistaLocation(String vistaLocation) {
        this.vistaLocation = vistaLocation;
    }

    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public PatientIdentifier getUserIdentifier() {
        return userIdentifier;
    }

    public void setUserIdentifier(PatientIdentifier userIdentifier) {
        this.userIdentifier = userIdentifier;
    }
}
