package com.agilex.vamf.missionhealth.domain;

import com.agilex.vamf.missionhealth.domain.enumeration.StandingType;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a user's current standing versus other mission health users
 */
@XmlRootElement(name = "missionHealthStanding", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MissionHealthStanding extends DomainTransferObject {

    /** The user's patient identifier */
    @XmlElement
    private String patientId;

    /** The user's name (aka Call Sign) */
    @XmlElement
    private String name;

    /** The user's branch of service */
    @XmlElement
    private String service;

    /** The user's current level */
    @XmlElement
    private Integer level;

    /** The user's current points */
    @XmlElement
    private Integer points;

    /** The user's current troops */
    @XmlElement
    private Integer troops;

    /** Indicates against what group of users this standing was calculated
     *      (i.e. vs all users, vs same service, vs same level)   */
    @XmlElement
    private StandingType type;

    /** The user's current standing */
    @XmlElement
    private Integer standing;

    public MissionHealthStanding() {

    }

    public MissionHealthStanding(String patientId, String name, String service, Integer level, Integer points,
                                 Integer troops, StandingType type, Integer standing) {
        this.patientId = patientId;
        this.name = name;
        this.service = service;
        this.level = level;
        this.points = points;
        this.troops = troops;
        this.type = type;
        this.standing = standing;
    }

    public String getPatientId() {
        return patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getPoints() {
        return points;
    }

    public void setPoints(Integer points) {
        this.points = points;
    }

    public Integer getTroops() {
        return troops;
    }

    public void setTroops(Integer troops) {
        this.troops = troops;
    }

    public StandingType getType() {
        return type;
    }

    public void setType(StandingType type) {
        this.type = type;
    }

    public Integer getStanding() {
        return standing;
    }

    public void setStanding(Integer standing) {
        this.standing = standing;
    }
}
