package com.agilex.vamf.missionhealth.domain;

/**
 * Represents a unique rank in the game.  A rank specific to a level and service.
 */
public class MissionHealthRank {

    /** The service for this rank */
    private String service;

    /** The level for this rank (0-15) */
    private Integer level = 0;

    /** The pay grade mapped to this rank */
    private String payGrade;

    /** An abbreviation for this rank */
    private String abbr;

    /** The title for this rank */
    private String title;

    /** A shortened version of the title of this rank */
    private String shortTitle;

    public MissionHealthRank() {
    }

    public MissionHealthRank(Integer level) {
        this.level = level;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getService() {
        return service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getAbbr() {
        return abbr;
    }

    public void setAbbr(String abbr) {
        this.abbr = abbr;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPayGrade() {
        return payGrade;
    }

    public void setPayGrade(String payGrade) {
        this.payGrade = payGrade;
    }

    public String getShortTitle() {
        return shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MissionHealthRank)) return false;

        MissionHealthRank that = (MissionHealthRank) o;

        if (!level.equals(that.level)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return level.hashCode();
    }
}
