package com.agilex.vamf.missionhealth.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.vamf.utils.DateMarshaller;

/**
 * An object that represents the user's profile.
 */
@XmlRootElement(name = "missionHealthProfile", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MissionHealthProfile extends DomainTransferObject {

	private static final long serialVersionUID = 7411643614177381588L;

	@XmlElement
	private String id;

	@XmlElement
	private String patientId;
	
	@XmlElement
	private PatientIdentifier patientIdentifier;

	@XmlElement
	private String name;

	@XmlElement
	private String service;

	@XmlElement
	private String gender;

	@XmlJavaTypeAdapter(DateMarshaller.class)
	private Date dateOfBirth;

	@XmlElement
	private String reminder;

	@XmlElement
	private String email;
	
	@XmlElement
	private String lastName;

    @XmlElement
    private String serviceLastRankedAs;
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public PatientIdentifier getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getService() {
		return service;
	}

	public void setService(String service) {
		this.service = service;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public Date getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getReminder() {
		return reminder;
	}

	public void setReminder(String reminder) {
		this.reminder = reminder;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}
	
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

    public String getServiceLastRankedAs() {
        return serviceLastRankedAs;
    }

    public void setServiceLastRankedAs(String serviceLastRankedAs) {
        this.serviceLastRankedAs = serviceLastRankedAs;
    }

    @Override
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}

}
