package com.agilex.vamf.missionhealth.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * A subset of fields from the user's {@link com.agilex.vamf.missionhealth.domain.MissionHealthDetail} object.
 */
@XmlRootElement(name = "MissionHealthPartialDetail", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MissionHealthPartialDetail extends PatientData{
	
	private static final long serialVersionUID = -2874760947202870057L;

    /** The total points earned by the user */
    @XmlElement
    private Integer points;

    /** The user's position in the overall standings (user's ranked by total points) */
    @XmlElement
    private Integer standing;

    /** Indicates if the user needs to see a message regarding lost troops. */
    @XmlElement
    private Boolean lostTroopsShowMessage;
	
	@XmlElement
    private Boolean promoted;
	
	
	public Integer getPoints() {
		return points;
	}


	public void setPoints(Integer points) {
		this.points = points;
	}


	public Integer getStanding() {
		return standing;
	}


	public void setStanding(Integer standing) {
		this.standing = standing;
	}


	public Boolean getLostTroopsShowMessage() {
		return lostTroopsShowMessage;
	}


	public void setLostTroopsShowMessage(Boolean lostTroopsShowMessage) {
		this.lostTroopsShowMessage = lostTroopsShowMessage;
	}


	public Boolean getPromoted() {
		return promoted;
	}


	public void setPromoted(Boolean promoted) {
		this.promoted = promoted;
	}


	@Override
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}
}
