package com.agilex.vamf.missionhealth.domain;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.vamf.missionhealth.domain.enumeration.MissionStatus;
import com.agilex.vamf.utils.DateMarshaller;

/**
 * Represents a user-created mission
 */
@XmlRootElement(name = "mission", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Mission extends DomainTransferObject {

	private static final long serialVersionUID = -6893376796675123909L;

	/** A unique identifier for the mission. By default it's generated as such (missionHealthDetailSID)"-"(order in which the mission was created).
     *      For example, the first mission created for a user with a missionHealthDetailSID = "ABC" would be "ABC-0" */
    @XmlElement(name="missionId")
	private String id;

    /** A name given to the mission by the user upon creation of the mission */
	@XmlElement
	private String name;

    /** The maximum points earned for completing this mission */
	@XmlElement
	private int totalPoints;

    /** The actual points earned for an ATTEMPTED or COMPLETED mission (i.e. should be <= totalPoints) at the end of the mission cycle */
	@XmlElement
	private int pointsWon;

    /** The points lost for an ATTEMPTED mission at the end of the mission cycle. This number of points will be given to the competing service for this mission */
	@XmlElement
	private int pointsForfeited;

    /** The percentage completion required to pass this mission */
	@XmlElement
	private String thresholdPercentage;

    /** The percentage of the mission that the user indicates that has been completed */
	@XmlElement
	private String percentageCompleted;

    /** The status of the mission. {@link com.agilex.vamf.missionhealth.domain.enumeration.MissionStatus} */
	@XmlElement
	private MissionStatus status;

    /** The user's service at the time when the mission was created */
	@XmlElement
	private String homeService;

    /** The service against which the user is competing */
	@XmlElement
	private String competingService;

    /** The date at which the mission was created */
	@XmlJavaTypeAdapter(DateMarshaller.class)
	private Date startDate;

    /** A description given to the mission by the user upon creation */
	@XmlElement
	private String description;

    /** A range of possible total points for this mission */
    @XmlElement
    private List<Integer> pointsRange;

    /** Indicates whether or not to show a mission completed/attempted popup for a previously COMPLETED or ATTEMPTED mission */
    @XmlElement
    private boolean showMessage = false;

    /** The troops lost for an ATTEMPTED mission at the end of a mission cycle. This number of troops will be given to the competing service for this mission */
    @XmlElement
    private Integer troopsForfeited = 0;
	
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getTotalPoints() {
		return totalPoints;
	}

	public void setTotalPoints(int totalPoints) {
		this.totalPoints = totalPoints;
	}

	public int getPointsWon() {
		return pointsWon;
	}

	public void setPointsWon(int pointsWon) {
		this.pointsWon = pointsWon;
	}

	public int getPointsForfeited() {
		return pointsForfeited;
	}

	public void setPointsForfeited(int pointsForfeited) {
		this.pointsForfeited = pointsForfeited;
	}

	public String getThresholdPercentage() {
		return thresholdPercentage;
	}

	public void setThresholdPercentage(String thresholdPercentage) {
		this.thresholdPercentage = thresholdPercentage;
	}

	public String getPercentageCompleted() {
		return percentageCompleted;
	}

	public void setPercentageCompleted(String percentageCompleted) {
		this.percentageCompleted = percentageCompleted;
	}

	public MissionStatus getStatus() {
		return status;
	}

	public void setStatus(MissionStatus status) {
		this.status = status;
	}

	public String getHomeService() {
		return homeService;
	}

	public void setHomeService(String homeService) {
		this.homeService = homeService;
	}

	public String getCompetingService() {
		return competingService;
	}

	public void setCompetingService(String competingService) {
		this.competingService = competingService;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

    public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

    public List<Integer> getPointsRange() {
        return pointsRange;
    }

    public void setPointsRange(List<Integer> pointsRange) {
        this.pointsRange = pointsRange;
    }

    public boolean isShowMessage() {
        return showMessage;
    }

    public void setShowMessage(boolean showMessage) {
        this.showMessage = showMessage;
    }
    
    public Integer getTroopsForfeited() {
		return troopsForfeited;
	}

	public void setTroopsForfeited(Integer troopsForfeited) {
		this.troopsForfeited = troopsForfeited;
	}

	@Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Mission)) return false;

        Mission mission = (Mission) o;

        if (!id.equals(mission.id)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}

}
