package com.agilex.vamf.missionhealth.domain;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.vamf.missionhealth.domain.atom.AtomLink;
import com.agilex.vamf.missionhealth.domain.atom.AtomLinks;
import com.agilex.vamf.missionhealth.domain.atom.rel;

/**
*
* @author j.ray
*/
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.MissionHealth)
public class DomainTransferObject implements Serializable, ObjectTypeable {

	private static final long serialVersionUID = 3029943740437406198L;
	private AtomLinks links = null;

	@XmlElement(name = "link", namespace = Namespace.Atom)
	public AtomLinks getLink() {
		if (this.links == null) {
			this.links = new AtomLinks();
		}

		return this.links;
	}
	
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}

	public AtomLink getSelfLink() {
		return getLink().getSelfLink();
	}

	public URI getSelfUri() {
		AtomLink link = getSelfLink();
		return AtomLink.extractUri(link);
	}

	public void setSelfUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.self);
		getLink().setSelfLink(link);
	}

}
