package com.agilex.vamf.missionhealth.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.NullChecker;

@XmlRootElement(name = "dataIdentifier", namespace = Namespace.MissionHealth)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DataIdentifier {
	@XmlAttribute
	private String uniqueId;
	@XmlAttribute
	private String systemId;

	private boolean areStringsEqual(String a, String b) {
		if (a == null)
			return b == null;
		if (b == null)
			return a == null;
		return a.contentEquals(b);
	}

	public DataIdentifier() {
	}

	public DataIdentifier(String systemId, String uniqueId) {
		this.systemId = systemId;
		this.uniqueId = uniqueId;
	}

	@Override
	public String toString() {
		final String delimitor = "#";
		String s;
		if (NullChecker.isNullish(getUniqueId())) {
			s = null;
		} else if (NullChecker.isNullish(getSystemId())) {
			s = getUniqueId();
		} else {
			s = getSystemId() + delimitor + getUniqueId();
		}
		return s;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getSystemId() {
		return systemId;
	}

	@Override
	public boolean equals(Object o) {
		if (o == null)
			return false;
		if (!(o instanceof DataIdentifier))
			return false;
		DataIdentifier identifier = (DataIdentifier) o;
		return (areStringsEqual(identifier.getUniqueId(), this.getUniqueId()) && areStringsEqual(identifier.getSystemId(), this.getSystemId()));
	}
	
	@Override
	//why do we have hashcode?
	public int hashCode() {
		int result = 17;
		result = 31 * result + (uniqueId == null ? 0 : uniqueId.hashCode());
		result = 31 * result + (systemId == null ? 0 : systemId.hashCode());
		return result;
	}
}
