package com.agilex.vamf.missionhealth.datalayer;

import javax.annotation.Resource;

import com.agilex.vamf.missionhealth.domain.*;
import com.agilex.vamf.missionhealth.domain.enumeration.StandingType;
import com.agilex.vamf.missionhealth.service.*;
import com.mongodb.DBCursor;

import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class MissionHealthDataLayerImpl implements MissionHealthDataLayer {

	@Resource
	MissionHealthDao missionHealthDao;
	
	@Override
	public MissionHealthDetail saveMissionHealthDetail(MissionHealthDetail missionHealthDetail) {
		return missionHealthDao.saveMissionHealthDetail(missionHealthDetail);
	}
	
	@Override
	public MissionHealthDetail getMissionHealthDetail(String patientId) {
        return missionHealthDao.getMissionHealthDetail(patientId);
	}
	
	@Override
	public MissionHealthDetail updateMissionHealthDetail(MissionHealthDetail mhd) {
		return missionHealthDao.updateMissionHealthDetail(mhd);
	}

	@Override
	public void removeMissionHealthDetail(MissionHealthDetail mhd) {
		missionHealthDao.removeMissionHealthDetail(mhd);
	}

    @Override
    public PointsRule getPointsRuleForLevel(Integer level) {
        return missionHealthDao.getPointsRuleForLevel(level);
    }

    @Override
    public Map<Integer, PointsRule> getPointsRuleMapping() {
        return missionHealthDao.getPointsRuleMapping();
    }

    @Override
    public MissionHealthRank getMissionHealthRank(String service, Integer level) {
        return missionHealthDao.getMissionHealthRank(service, level);
    }

    @Override
    public Map<Integer, Map<String, MissionHealthRank>> getMissionHealthRankMapping() {
        return missionHealthDao.getMissionHealthRankMapping();
    }

    @Override
    public MissionHealthDetails getAllMissionHealthDetails() {
        return missionHealthDao.getAllMissionHealthDetails();
    }

    @Override
    public DBCursor getWeeklyJobCursor() {
        return missionHealthDao.getWeeklyJobCursor();
    }

    @Override
    public MissionHealthWeeklyStatus fetchMostRecentMissionHealthWeeklyStatus() {
        return missionHealthDao.fetchMostRecentMissionHealthWeeklyStatus();
    }

    @Override
    public void saveMissionHealthWeeklyStatus(MissionHealthWeeklyStatus missionHealthWeeklyStatus) {
        missionHealthDao.saveMissionHealthWeeklyStatus(missionHealthWeeklyStatus);
    }

    @Override
    public Integer getTotalMissionsAcrossAllUsers() {
        return missionHealthDao.getTotalMissionsAcrossAllUsers();
    }

    @Override
    public MissionHealthWeeklyStatus getMetricsForAllUsers(MissionHealthWeeklyStatus missionHealthWeeklyStatus) {
        return missionHealthDao.getMetricsForAllUsers(missionHealthWeeklyStatus);
    }

    @Override
    public List<WeeklyServiceMetrics> getMetricsByService() {
        return missionHealthDao.getMetricsByService();
    }

    @Override
    public void updateWeeklyStanding(MissionHealthDetail missionHealthDetail) {
        missionHealthDao.updateWeeklyStanding(missionHealthDetail);
    }

    @Override
    public MissionHealthStandings getMissionHealthStandings(MissionHealthDetail missionHealthDetail){
        return missionHealthDao.getMissionHealthStandings(missionHealthDetail);
    }

    @Override
    public MissionHealthStandings getMissionHealthStandings(MissionHealthDetail missionHealthDetail, StandingType standingType){
        return missionHealthDao.getMissionHealthStandings(missionHealthDetail, standingType);
    }

    @Override
    public void saveWeeklyUserMetrics(WeeklyUserMetrics weeklyUserMetrics) {
        missionHealthDao.saveWeeklyUserMetrics(weeklyUserMetrics);
    }

    @Override
    public List<WeeklyUserMetrics> getWeeklyUserMetricsByDate(Date createDatetime) {
        return missionHealthDao.getWeeklyUserMetricsByDate(createDatetime);
    }

    @Override
    public void clearWeeklyStanding() {
        missionHealthDao.clearWeeklyStanding();
    }
    
    @Override
	public AnnualServiceRollUp annualServiceComparisonRollUp(String date,
			AnnualServiceRollUp annualServiceRollUp) {
		return missionHealthDao.annualServiceComparisonRollUp(date,annualServiceRollUp);
	}

	@Override
	public List<WeeklyServiceMetrics> getAnnualMetricsByService(String date) {
		return  missionHealthDao.getAnnualMetricsByService(date);
	}

    @Override
    public void triggerWeeklyTasks() {
        missionHealthDao.triggerWeeklyTasks();
    }

    @Override
    public MissionHealthWeeklyStatus startWeeklyTasks() {
        return missionHealthDao.startWeeklyTasks();
    }

    @Override
    public void triggerNotificationTask(String notificationType) {
        missionHealthDao.triggerNotificationTask(notificationType);
    }

    @Override
    public MissionHealthNotificationStatus startNotificationTask(String notificationType) {
        return missionHealthDao.startNotificationTask(notificationType);
    }

    @Override
    public void saveNotificationStatus(MissionHealthNotificationStatus missionHealthNotificationStatus) {
        missionHealthDao.saveNotificationStatus(missionHealthNotificationStatus);
    }
}