package com.agilex.vamf.missionhealth.datalayer;

import com.agilex.vamf.missionhealth.domain.*;
import com.agilex.vamf.missionhealth.domain.enumeration.StandingType;
import com.agilex.vamf.missionhealth.service.*;
import com.mongodb.DBCursor;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface MissionHealthDataLayer {

    public MissionHealthDetail saveMissionHealthDetail(MissionHealthDetail missionHealthDetail);

    public MissionHealthDetail getMissionHealthDetail(String patientId);

    public MissionHealthDetail updateMissionHealthDetail(MissionHealthDetail mhd);

    public void removeMissionHealthDetail(MissionHealthDetail mhd);

    public PointsRule getPointsRuleForLevel(Integer level);

    public Map<Integer, PointsRule> getPointsRuleMapping();

    public MissionHealthRank getMissionHealthRank(String service, Integer level);

    public Map<Integer, Map<String, MissionHealthRank>> getMissionHealthRankMapping();

    public MissionHealthDetails getAllMissionHealthDetails();

    public DBCursor getWeeklyJobCursor();

    public MissionHealthWeeklyStatus fetchMostRecentMissionHealthWeeklyStatus();

    public void saveMissionHealthWeeklyStatus(MissionHealthWeeklyStatus missionHealthWeeklyStatus);

    public Integer getTotalMissionsAcrossAllUsers();

    public MissionHealthWeeklyStatus getMetricsForAllUsers(MissionHealthWeeklyStatus missionHealthWeeklyStatus);

    public List<WeeklyServiceMetrics> getMetricsByService();

    public void updateWeeklyStanding(MissionHealthDetail missionHealthDetail);

    public MissionHealthStandings getMissionHealthStandings(MissionHealthDetail missionHealthDetail);

    public MissionHealthStandings getMissionHealthStandings(MissionHealthDetail missionHealthDetail, StandingType standingType);

    public void saveWeeklyUserMetrics(WeeklyUserMetrics weeklyUserMetrics);

    public List<WeeklyUserMetrics> getWeeklyUserMetricsByDate(Date createDatetime);

    public void clearWeeklyStanding();
    
    public AnnualServiceRollUp annualServiceComparisonRollUp(String date,AnnualServiceRollUp annualServiceRollUp);
    
    public List<WeeklyServiceMetrics> getAnnualMetricsByService(String date);

    public void triggerWeeklyTasks();

    public MissionHealthWeeklyStatus startWeeklyTasks();

    public void triggerNotificationTask(String notificationType);

    public MissionHealthNotificationStatus startNotificationTask(String notificationType);

    public void saveNotificationStatus(MissionHealthNotificationStatus missionHealthNotificationStatus);
}
