package com.agilex.vamf.missionhealth.testutility;

import com.agilex.vamf.missionhealth.clientapi.AuthenticationInfo;
import com.agilex.vamf.missionhealth.clientapi.MobileHealthClientTestVersion;
import com.sun.jersey.api.client.Client;

public class TestHelper {
	public static MobileHealthClientTestVersion createMobileHealthClient() {
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getAuthenticationInformation();
		return createMobileHealthClient(authenticationInfo);
	}
	
	public static Client createJerseyClient() {
		return createMobileHealthClient().getJerseyClient();
	}

    public static MobileHealthClientTestVersion createMobileHealthClient(String username, String password, String authType) {
		AuthenticationInfo authenticationInfo = new AuthenticationInfo(username, password, authType);
		
		return createMobileHealthClient(authenticationInfo);
	}
	
	public static MobileHealthClientTestVersion createMobileHealthClient(AuthenticationInfo authenticationInfo) {
		String uri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
		MobileHealthClientTestVersion mobileHealthClient = new MobileHealthClientTestVersion(uri, authenticationInfo);
		return mobileHealthClient;
	}

	
	public static boolean beginsWith(String value, String compareTo) {
		int length = compareTo.length();
		String beginning = value.substring(0, length);
		return beginning.toLowerCase().contentEquals(compareTo.toLowerCase());
	}

	

}
