package com.agilex.vamf.missionhealth.testutility;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.w3c.dom.Document;

import com.agilex.vamf.missionhealth.clientapi.MobileHealthClientTestVersion;
import com.agilex.vamf.missionhealth.domain.Patient;
import com.agilex.vamf.missionhealth.domain.PatientIdentifier;

public class PatientLoader {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PatientLoader.class);

	public static Patient loadPatient(PatientIdentifier patientIdentifier, String userName, String password, String authType) {
		URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
		logger.debug("loading patient using url " + patientUri);

		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(userName, password, authType);
		Patient patient = client.getJerseyClient().resource(patientUri).get(Patient.class);
		assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
		return patient;
	}

	public static Patient loadPatient(PatientIdentifier patientIdentifier, String userName) {
		return loadPatient(patientIdentifier, userName, "pass", "oauth");
	}
	
	public static Document loadPatientAsXml(PatientIdentifier patientIdentifier, String userName, String password, String authType) {
		URI patientUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
		logger.debug("loading patient using url " + patientUri);

		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(userName, password, authType);
		Document patient = client.getJerseyClient().resource(patientUri).get(Document.class);
		assertNotNull("failed to retrieve patient [id=" + patientIdentifier + "]", patient);
		return patient;
	}

	public static Patient loadTestPatient() {
		return loadPatient(IntegrationTestConfiguration.getTestPatient(), "zztest.patient01");
	}

	private static Patient loadPatient(Patient patient, String userName) {
		return loadPatient(patient.getPatientIdentifier(), userName);
	}

}
