package com.agilex.vamf.missionhealth.testutility;

import java.net.URI;
import java.util.Map;

import javax.ws.rs.core.UriBuilder;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;

import com.agilex.vamf.missionhealth.clientapi.AuthenticationInfo;
import com.agilex.vamf.missionhealth.domain.Patient;
import com.agilex.vamf.utils.NullChecker;
import com.sun.jersey.api.client.Client;

@SuppressWarnings("unchecked")
public class IntegrationTestConfiguration {

    public static final String CONFIGURATION_FILENAME = "integrationApplicationContext.xml";
    private static Map<String, String> properties = null;
    private static BeanFactory factory;

    static {
        factory = new ClassPathXmlApplicationContext(new String[] { CONFIGURATION_FILENAME });
        properties = (Map<String, String>) factory.getBean("configProperties");
    }

    public static Patient getPatient(String patientKey) {
        return (Patient) factory.getBean(patientKey);
    }

    public static Patient getTestPatient() {
        return getPatient("patientYounger");
    }

    public static Patient getTestInpatient() {
        return getPatient("testInpatient");
    }

    public static Patient getPatientSmithWithSSN() {
        return getPatient("patientSmithWithSSN");
    }

    public static Patient getTestPatientWithoutMiddleName() {
        return getPatient("patientWithoutMiddleName");
    }

    public static Patient getTestPatientWithSpaceInName() {
        return getPatient("patientWithSpaceInName");
    }

    public static String getMobileHealthServerBaseUri() {
        return getProperty("MissionHealthServiceWebBaseURI");
    }
	
    public static String getAssigningAuthority() {
		return getProperty("assigningAuthority");
	}
	
	public static String getPatientId() {
		return getProperty("patientId");
	}
	
    public static URI getHealthAdapterResourceDirectoryUri() {
        URI resourceDirectory = UriBuilder.fromUri(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("resource-directory").build();
        return resourceDirectory;
    }

    public static URI getResourceUri(String resourceTitle) {
        Client jerseyClient = new Client();
        Document resources = jerseyClient.resource(IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri()).get(Document.class);
        return XpathHelper.getUri(resources, "//item[title='" + resourceTitle +  "']/link");
    }


    public static String getMHPAuthorizeURI() {
        return getProperty("MHPAuthorizeURI");
    }

    public static String getMHPTokenURI() {
        return getProperty("MHPTokenURI");
    }

    public static String getMHBaseURI() {
        return getProperty("MHPBaseURI");
    }

    public static AuthenticationInfo getAuthenticationInformation() {
        AuthenticationInfo authenticationInfo = null;
        if (NullChecker.isNotNullish(getAuthType())) {
            authenticationInfo = new AuthenticationInfo();
            authenticationInfo.setUsername(getUsername());
            authenticationInfo.setPassword(getPassword());
            authenticationInfo.setAuthtype(getAuthType());
            authenticationInfo.setFacilityName(getFacilityName());
            authenticationInfo.setFacilityCode(getFacilityCode());
        }
        return authenticationInfo;
    }

    private static String getUsername() {
        return getProperty("username");
    }

    private static String getPassword() {
        return getProperty("password");
    }

    private static String getAuthType() {
        String authtype = getProperty("authtype");
        return authtype;
    }

    private static String getFacilityName() {
        String authtype = getProperty("facilityName");
        return authtype;
    }

    private static String getFacilityCode() {
        String authtype = getProperty("facilityCode");
        return authtype;
    }

    private static String getProperty(String key) {
        return properties.get(key);
    }

}
