package com.agilex.vamf.missionhealth.restservice;

import java.net.URI;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import com.agilex.vamf.missionhealth.domain.*;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import junit.framework.Assert;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.vamf.missionhealth.clientapi.AuthenticationInfo;
import com.agilex.vamf.missionhealth.clientapi.MobileHealthClientTestVersion;
import com.agilex.vamf.missionhealth.clientapi.ModeHelper;
import com.agilex.vamf.missionhealth.testutility.IntegrationTestConfiguration;
import com.agilex.vamf.missionhealth.testutility.TestHelper;
import com.agilex.vamf.missionhealth.uri.LinkTitles;
import com.agilex.vamf.utils.DateHelper;

public class MissionHealthResourceTest {

	private static MobileHealthClientTestVersion client;
	private String assigningAuthority;
	private String patientId;
	private URI missionHealthUri;

	@BeforeClass
	public static void startup() {
      if(ModeHelper.isMode("va-veteran-dev"))
		    client = TestHelper.createMobileHealthClient();
 	}
	
	@Before
	public void createClient() {
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getAuthenticationInformation();
		client = TestHelper.createMobileHealthClient(authenticationInfo);
		
		assigningAuthority = IntegrationTestConfiguration.getAssigningAuthority();
        patientId = IntegrationTestConfiguration.getPatientId();
        missionHealthUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(assigningAuthority).path(patientId). path(LinkTitles.MissionHealth).build();
    }
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validateFetchMissionHealthResourceDirectory() {
		
			ResourceDirectory resourceDirectory = client.getJerseyClient().resource(missionHealthUri).type(MediaType.APPLICATION_XML).get(ResourceDirectory.class);
			Assert.assertNotNull(resourceDirectory);
	}
	
	@Test
	public void validateFetchMissionHealthDetail() {
		
			URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();
			
			MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
			Assert.assertNotNull(missionHealthDetail);
			Assert.assertNotNull(missionHealthDetail.getId());
	}
	
	
	@Test
	public void validateSaveMissionHealthProfile() {
		
			MissionHealthProfile missionHealthProfile = new MissionHealthProfile();
			missionHealthProfile.setPatientId(patientId);
			missionHealthProfile.setName("lastNameNew");
			missionHealthProfile.setDateOfBirth(DateHelper.parseDate("07/02/1980"));
			missionHealthProfile.setGender("M");
			missionHealthProfile.setReminder("Daily");
			missionHealthProfile.setEmail("test@agilexhealth.com");
			missionHealthProfile.setService("Army");
			
			URI saveMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-profile").build();
			
			MissionHealthDetail savedMissionHealthDetail = client.getJerseyClient().resource(saveMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).put(MissionHealthDetail.class, missionHealthProfile);
			Assert.assertNotNull(savedMissionHealthDetail);
			Assert.assertNotNull(savedMissionHealthDetail.getId());
	}

	@Deprecated
	@Ignore
	@Test
	public void validateFetchMissionHealthProfile() {
		
			URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-profile").build();
			
			MissionHealthProfile missionHealthProfile = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthProfile.class);
			Assert.assertNotNull(missionHealthProfile);
			Assert.assertNotNull(missionHealthProfile.getId());
	}

    @Ignore
    @Test
    public void validateCreateMissionHealthProfile(){/* TODO: Write Test!*/}
	
	
	@Test
	public void validateFetchSmartInfoPoints() {
		
			URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("smartinfo-points").build();
			
			MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
			Assert.assertNotNull(missionHealthDetail);
			Assert.assertNotNull(missionHealthDetail.getPoints());
	}
	
	
	@Test
	public void validateFetchEmailFacebookPoints() {
		
			URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("emailfacebook-points").build();
			
			MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
			Assert.assertNotNull(missionHealthDetail);
			Assert.assertNotNull(missionHealthDetail.getPoints());
	}

    @Test
    public void validateCreateNewMission() {
        URI fetchMissionHealthDetailURL = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();

        MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthDetailURL).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
        Assert.assertNotNull(missionHealthDetail);

        if(null==missionHealthDetail.getMissionHealthProfile())
            createProfile();

        URI createNewMissionURI = UriBuilder.fromUri(missionHealthUri).path("mission").build();

        Mission mission = new Mission();
        mission.setName("Mission 1");
        mission.setDescription("First Test Mission");
        mission.setCompetingService("Air Force");
        mission = client.getJerseyClient().resource(createNewMissionURI).accept(MediaType.APPLICATION_JSON).post(Mission.class, mission);
        Assert.assertNotNull(mission);
        Assert.assertNotNull(mission.getTotalPoints());
        Assert.assertTrue(mission.getTotalPoints()>0);
    }

    @Test
    public void validateUpdateCurrentMission() {
        URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();

        MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
        Assert.assertNotNull(missionHealthDetail);

        URI missionURI = UriBuilder.fromUri(missionHealthUri).path("mission").build();
        Mission mission = new Mission();
        mission.setName("Mission 2");
        mission.setDescription("Second Test Mission");
        mission.setCompetingService("Army");
        mission = client.getJerseyClient().resource(missionURI).accept(MediaType.APPLICATION_JSON).post(Mission.class, mission);
        Assert.assertNotNull(mission);
        Assert.assertNotNull(mission.getTotalPoints());

        mission.setPercentageCompleted("80%");
        mission = client.getJerseyClient().resource(missionURI).accept(MediaType.APPLICATION_JSON).put(Mission.class, mission);
        Assert.assertNotNull(mission);
        Assert.assertNotNull(mission.getPercentageCompleted());
    }
    
    @Test
    public void validateInsertMissionReadinessReport() {
        URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();

        MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
        Assert.assertNotNull(missionHealthDetail);

        URI insertMissionReadinessReportURI = UriBuilder.fromUri(missionHealthUri).path("mission-readiness-report").build();

        MissionReadinessReport missionReadinessReport = new MissionReadinessReport();
        if((missionHealthDetail.getRank().equals(new MissionHealthRank(0)) && missionHealthDetail.getMissionReadinessReports().size()==0)){
        MissionHealthDetail mhd = client.getJerseyClient().resource(insertMissionReadinessReportURI).accept(MediaType.APPLICATION_JSON).post(MissionHealthDetail.class, missionReadinessReport);
        Assert.assertNotNull(mhd);
        Assert.assertNotNull(mhd.getMissionReadinessReports());
        Assert.assertEquals(false, mhd.getMissionReadinessReports().isEmpty());
       }
    }
    
    @Test
    public void validateSavePromotedStatus() {       
        URI promotedURI = UriBuilder.fromUri(missionHealthUri).path("promoted").build();
        MissionHealthDetail mhd=client.getJerseyClient().resource(promotedURI).accept(MediaType.APPLICATION_JSON).put(MissionHealthDetail.class);
        
        Assert.assertNotNull(mhd);
        Assert.assertEquals(false,mhd.isPromoted());
    }
    
    @Test
    public void validateSaveLostTroopsShowMessage() {       
        URI lostTroopsURI = UriBuilder.fromUri(missionHealthUri).path("lost-troops").build();
        MissionHealthDetail mhd=client.getJerseyClient().resource(lostTroopsURI).accept(MediaType.APPLICATION_JSON).put(MissionHealthDetail.class);
        
        Assert.assertNotNull(mhd);
        Assert.assertEquals(false,mhd.isLostTroopsShowMessage());
    }

    private void createProfile(){
        MissionHealthProfile missionHealthProfile = new MissionHealthProfile();
        missionHealthProfile.setPatientId(patientId);
        missionHealthProfile.setName("lastNameNew");
        missionHealthProfile.setDateOfBirth(DateHelper.parseDate("07/02/1980"));
        missionHealthProfile.setGender("M");
        missionHealthProfile.setReminder("Daily");
        missionHealthProfile.setEmail("test@agilexhealth.com");
        missionHealthProfile.setService("Army");

        URI createMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-profile").build();
        missionHealthProfile = client.getJerseyClient().resource(createMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).post(MissionHealthProfile.class, null);
    }
    
    @Ignore
    @Test
    public void validateFetchAnnualServiceComparisonRollUp() {       
        URI lostTroopsURI = UriBuilder.fromUri(missionHealthUri).path("annual-rollup").build();
        AnnualServiceRollUp asru=client.getJerseyClient().resource(lostTroopsURI).accept(MediaType.APPLICATION_JSON).get(AnnualServiceRollUp.class);
        
        Assert.assertNotNull(asru);
      }

    @Test
    public void getMissionHealthUserTest(){
        URI mhUserUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("mhpuser").build();
        MissionHealthUser user = client.getJerseyClient().resource(mhUserUri).accept(MediaType.APPLICATION_JSON).get(MissionHealthUser.class);
        Assert.assertNotNull(user);
        Assert.assertNotNull(user.getLastName());
        Assert.assertNotNull(user.getUserIdentifier());
    }
}