package com.agilex.vamf.missionhealth.restservice;

import java.net.URI;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import com.agilex.vamf.missionhealth.domain.*;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import junit.framework.Assert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.junit.ContiPerfRule;
import org.junit.*;

import com.agilex.vamf.missionhealth.clientapi.AuthenticationInfo;
import com.agilex.vamf.missionhealth.clientapi.MobileHealthClientTestVersion;
import com.agilex.vamf.missionhealth.clientapi.ModeHelper;
import com.agilex.vamf.missionhealth.testutility.IntegrationTestConfiguration;
import com.agilex.vamf.missionhealth.testutility.TestHelper;
import com.agilex.vamf.missionhealth.uri.LinkTitles;
import com.agilex.vamf.utils.DateHelper;

public class MissionHealthResourcePerfTest {

	private static MobileHealthClientTestVersion client;
	private String assigningAuthority;
	private String patientId;
	private URI missionHealthUri;

    private static final Log logger = LogFactory.getLog(MissionHealthResourcePerfTest.class);

    @Rule
    public ContiPerfRule rule = new ContiPerfRule();

	@BeforeClass
	public static void startup() {
      if(ModeHelper.isMode("va-veteran-dev"))
		    client = TestHelper.createMobileHealthClient();
 	}
	
	@Before
	public void createClient() {
		AuthenticationInfo authenticationInfo = IntegrationTestConfiguration.getAuthenticationInformation();
		client = TestHelper.createMobileHealthClient(authenticationInfo);
		
		assigningAuthority = IntegrationTestConfiguration.getAssigningAuthority();
        patientId = IntegrationTestConfiguration.getPatientId();
        missionHealthUri = UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("patient").path(assigningAuthority).path(patientId). path(LinkTitles.MissionHealth).build();
    }
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
    @PerfTest(invocations = 5, threads= 1)
    public void validateFetchMissionHealthDetail() {
        URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();
			
		MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
		Assert.assertNotNull(missionHealthDetail);
		Assert.assertNotNull(missionHealthDetail.getId());
	}

    @Test
    @Ignore
    @PerfTest(invocations = 200, threads= 50)
    public void multiThreadedConnectionTest(){
        int fetchCount = 3;
        for(int i=0; i<fetchCount; i++){
            URI fetchMissionHealthProfileURI = UriBuilder.fromUri(missionHealthUri).path("mission-health-detail").build();
            MissionHealthDetail missionHealthDetail = client.getJerseyClient().resource(fetchMissionHealthProfileURI).accept(MediaType.APPLICATION_JSON).get(MissionHealthDetail.class);
            Assert.assertNotNull(missionHealthDetail);
            Assert.assertNotNull(missionHealthDetail.getId());
        }

    }

}