package gov.va.med.mhv.sm.api.mock;

import java.util.Date;

import org.apache.commons.lang.NotImplementedException;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.SendMessageService;

public class SendMessageServiceImpl implements SendMessageService {

	@Override
	public ServiceResponse<Message> send(NewMessage nm) {
		ServiceResponse<Message> response = new ServiceResponse<Message>();
		
		Message m = new Message();
		m.setActive(true);
		m.setAttachment(true);
		m.setBody("This is the body of a message");
		m.setId(1111l);
		m.setCreatedDate(new Date());
		m.setAttachmentId(998l);
		m.setReadReceipt("READ");
		m.setSenderId(123l);
		
		TriageGroup tg1 = new TriageGroup();
		tg1.setActive(true);
		tg1.setId(889l);
		tg1.setName("Triage Group 1");
		
		gov.va.med.mhv.sm.model.Thread t = new gov.va.med.mhv.sm.model.Thread();
		t.setActive(true);
		t.setMailGroup(tg1);
		t.setMessageCategoryType(MessageCategoryTypeEnum.MEDICATIONS);
		t.setSubject("This is the subject");
		
		m.setThread(t);
		
		return response;
	}
	
	/*========================================================================*/

	@Override
	public void addressMessage(Message m, User u, SystemFolderEnum folder,
			boolean sendToSurrogate) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<NewMessage> draftToNewMessage(User u, Long messageId) {
		throw new NotImplementedException();
	}

	@Override
	public CollectionServiceResponse<TriageGroup> getTriageGroupsAllActive() {
		throw new NotImplementedException();
	}

	@Override
	public CollectionServiceResponse<TriageGroup> getTriageGroupsForStation(
			String station) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> reply(Message orig, NewMessage nm) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> replyFromSentFolder(Message orig,
			NewMessage nm) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> saveDraft(NewMessage nm, Long messageId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> saveReplyDraft(Message orig, NewMessage nm) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> sendDraft(NewMessage nm, Long messageId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> sendReplyDraft(Message orig, NewMessage nm) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Message> sendReplyDraftForAPI(Message arg0,
			NewMessage arg1) {
		// TODO Auto-generated method stub
		return null;
	}

}
