package gov.va.med.mhv.sm.api.mock;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ReAssignMessageActionEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MessageService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.NotImplementedException;

public class MessageServiceImpl implements MessageService {

	@Override
	public ServiceResponse<Message> fetchMessage(Long id) {
		ServiceResponse<Message> response = new ServiceResponse<Message>();
		
		List<Addressee> addressees = new ArrayList<Addressee>();
		Addressee a1 = new Addressee();
		a1.setActive(true);
		a1.setId(999l);
		
		Addressee a2 = new Addressee();
		a2.setActive(true);
		a2.setId(1000l);
		
		addressees.add(a1);
		addressees.add(a2);
		
		TriageGroup tg1 = new TriageGroup();
		tg1.setActive(true);
		tg1.setId(889l);
		tg1.setName("Triage Group 1");
		
		gov.va.med.mhv.sm.model.Thread t = new gov.va.med.mhv.sm.model.Thread();
		t.setActive(true);
		t.setMailGroup(tg1);
		t.setMessageCategoryType(MessageCategoryTypeEnum.MEDICATIONS);
		t.setSubject("This is the subject");
		
		Message m = new Message();
		m.setActive(true);
		m.setAddressees(addressees);
		m.setAttachment(true);
		m.setBody("This is the body of a message");
		m.setId(id);
		m.setCreatedDate(new Date());
		m.setAttachmentId(998l);
		m.setReadReceipt("READ");
		m.setSenderId(123l);
		m.setThread(t);
		m.setSentDate(new Date());
		
		response.setPayload(m);
		
		return response;
	}

	@Override
	public ServiceResponse<MessageAttachment> saveAttachment(byte[] attachment,
			String fileName, String mimeType) {
		ServiceResponse<MessageAttachment> response = new ServiceResponse<MessageAttachment>();
		
		MessageAttachment ma = new MessageAttachment();
		ma.setActive(true);
		ma.setAttachmentName(fileName);
		ma.setCreatedDate(new Date());
		ma.setId(20999l);
		ma.setMimeType(mimeType);
		
		response.setPayload(ma);
		
		return response;
	}
	
	@Override
	public ServiceResponse<Boolean> moveMessage(Message m, User u, Folder f) {
		
		ServiceResponse<Boolean> response = new ServiceResponse<Boolean>();
		
		return response;
	}
	
	/*========================================================================*/
	
	@Override
	public ServiceResponse<Boolean> annotateThread(Annotation a) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> assignMessage(Message m,
			Clinician assignTo, Clinician assignedBy) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> assignMessageAndUpdateHistory(
			Message message, Clinician assignedTo, Clinician assignedBy,
			String assignedToWithSurrogate) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> completeIndividualMessage(Message message,
			Clinician user) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> completedMessageReassignment(Message m,
			Clinician assignedBy, Long assignedTo, String annotation,
			String surrogateEnabled) {
		throw new NotImplementedException();
	}

	@Override
	public void deleteAddresseeReminders(Long addresseeId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> deleteDraft(User u, Long messageId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> deleteMessage(Message m, User u) {
		throw new NotImplementedException();
	}

	
	@Override
	public Message findMessageById(Long id) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<User> getSender(Long Id) {
		throw new NotImplementedException();
	}

	@Override
	public void markReadAsUnread(Addressee ad) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> moveMessage(Addressee a) {
		throw new NotImplementedException();
	}

	public ServiceResponse<Message> reAssignMessageToAnotherTriageGroup(
			Message currentMessage, Long assignedToTriageGroupId, User user) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> readMessage(Message m, User u) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> recall(Long messageId, Clinician clinician) {
		throw new NotImplementedException();
	}

	@Override
	public void removeAttachment(Long attachmentId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> setAllPreviousMessageStatus(Message m,
			ClinicianStatusEnum status, Clinician setBy,
			Long newReplyMessageId, Date reminderDate) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> setMessageStatus(Message m,
			ClinicianStatusEnum status, Clinician setBy, Date reminderDate) {
		throw new NotImplementedException();
	}

	@Override
	public void updateAddresseeReAssignedActive(Message message) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> updateAssignmentStatus(Long messageId,
			Clinician clinician) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Message> updateReadReceipt(Long messageId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<MessageAttachment> fetchAttachment(Long attachmentId) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Boolean> nofityFacilityAdminsAddPatientToFacility(
			Long arg0, Long arg1, User arg2) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Message> reAssignMessage(Long arg0, Long arg1,
			Long arg2, Long arg3, Boolean arg4, User arg5,
			ReAssignMessageActionEnum arg6) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Message> reAssignMessageToAnotherStaff(Message arg0,
			Long arg1, Long arg2, Long arg3, Boolean arg4, User arg5) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Message> reAssignMessageToAnotherTriageGroup(
			Message arg0, Long arg1, Long arg2, Boolean arg3, User arg4) {
		// TODO Auto-generated method stub
		return null;
	}

}
