package gov.va.med.mhv.sm.api.mock;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.dto.SearchFormDTO;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Mailbox;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.SystemFolder;
import gov.va.med.mhv.sm.service.MailboxService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.NotImplementedException;

public class MailboxServiceImpl implements MailboxService {

	@Override
	public ServiceResponse<Patient> getMailbox(Patient p) {
		ServiceResponse<Patient> response = new ServiceResponse<Patient>();
		Mailbox m = new Mailbox();
		
		Map<Long,Folder> folders = new HashMap<Long,Folder>();
		SystemFolder inbox = new SystemFolder();
		inbox.setActive(true);
		inbox.setCount(99);
		inbox.setId(0l);
		inbox.setUnreadCount(44);
		inbox.setOwner(p);
		inbox.setName("inbox");
		folders.put(inbox.getId(), inbox);
		
		SystemFolder sent = new SystemFolder();
		sent.setActive(true);
		sent.setCount(99);
		sent.setId(-1l);
		sent.setUnreadCount(44);
		sent.setOwner(p);
		sent.setName("sent");
		folders.put(sent.getId(), sent);
		
		Folder userfolder = new Folder();
		userfolder.setActive(true);
		userfolder.setCount(99);
		userfolder.setId(12l);
		userfolder.setUnreadCount(44);
		userfolder.setOwner(p);
		userfolder.setName("userfolder");
		folders.put(userfolder.getId(), userfolder);
		
		m.setFolders(folders);
		
		List<SystemFolder> sFolders = new ArrayList<SystemFolder>();
		sFolders.add(inbox);
		sFolders.add(sent);
		m.setSystemFolders(sFolders);
		
		List<Folder> uFolders = new ArrayList<Folder>();
		uFolders.add(userfolder);
		m.setUserFolders(uFolders);
		
		p.setMailbox(m);
		response.setPayload(p);
		return response;
	}
	
	@Override
	public ServiceResponse<Folder> getMessages(Folder f) {
		// TODO Auto-generated method stub
		return null;
	}
	
	/*========================================================================*/
	
	@Override
	public ServiceResponse<Boolean> renameUserFolder(Folder f) {
		throw new NotImplementedException();
	}
	
	@Override
	public ServiceResponse<Boolean> addUserFolder(Folder f) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Boolean> deleteUserFolder(Long folderId) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Clinician> getMailbox(Clinician c) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Folder> getMessages(Folder f, MessagesPageEnum page) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Folder> getMessages(Folder f, SearchFormDTO sf) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Folder> getMessages(Folder f, MessagesPageEnum page,
			SearchFormDTO sf) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Patient> updateCounts(Patient p) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Clinician> updateCounts(Clinician c) {
		throw new NotImplementedException();
	}

	@Override
	public ServiceResponse<Patient> getMailbox(Patient p, boolean preloadInbox) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceResponse<Clinician> getMailbox(Clinician c,
			boolean preloadInbox) {
		// TODO Auto-generated method stub
		return null;
	}

}
