package client;

import gov.va.med.mhv.sm.api.transfer.ClinicianMessageTO;
import gov.va.med.mhv.sm.api.transfer.JunkTO;
import gov.va.med.mhv.sm.api.transfer.MessageTO;
import gov.va.med.mhv.sm.api.transfer.PatientMessageTO;
import gov.va.med.mhv.sm.api.util.ClientApplicationHelper;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

import org.apache.commons.httpclient.util.DateUtil;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.codehaus.jackson.map.ObjectMapper;

public class TestClientClinician {

	static String HOST="http://localhost:7001";
//	static String HOST ="http://serverserver1.domain.ext:7010";
//	static String HOST ="https://sm-intb.myhealth.domain";
//	static String HOST ="http://srv-serv.myhealth.domain";
	
	static List<Object> PROVIDERS = new ArrayList<Object>();
    static {
    	PROVIDERS.add(new org.codehaus.jackson.jaxrs.JacksonJsonProvider());
    	//HOST="http://localhost";
    	//HOST="http://serverserver1.domain.ext:7010";
    }
    
	public static void main(String[] args) {
	
//		TEST_READ_MESSAGE();
//		TEST_SEND_MESSAGE();
//		TEST_REPLY_MESSAGE_();
		TEST_DELETE_MESSAGE();
	
	}
	public static void TEST_READ_MESSAGE() {
		long s = System.currentTimeMillis();
		ClinicianApp app = new ClinicianApp(ClientApplicationHelper.findClientApplication(101l).getAppToken());
		
		
		// LocalHost - Syamala @ 991 SLC4
		//ClinicianUser("vhaiswpakals","991", 59838l );
		// LocalHost - Johnnie @ 991 SLC4
		//ClinicianUser("VHAISWBOYETJ","991", 59823l );
		
		//ClinicianUser user = new ClinicianUser("VHAISWBOYETJ","991", 59823l );// LOCALHOST
		ClinicianUser user = new ClinicianUser("vhaiswpakals","991", 59838l );
		//ClinicianUser user = new ClinicianUser(531263l);// INTB
		ClinicianClientSession session = new ClinicianClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		ClinicianMessageTO msg = testReadMessage(prepareHeaders( session ), "application/json", "application/json", 225405l);
		//testReplyMessage(session, "application/json", "application/json");
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("READ message DONE: " +msg.getBody());
		if (msg !=null) {
			List lt = msg.getInformationMessages().getInformationMessage();
			Iterator it = lt.iterator();
			while (it.hasNext()) {
				String str =(String) it.next();
				System.out.println("MESG:: " +str);
			}
		}
	}
	
	public static void TEST_SEND_MESSAGE() {
		try {
			long s = System.currentTimeMillis();
			ClinicianApp app = new ClinicianApp(ClientApplicationHelper.findClientApplication(101l).getAppToken());
			
			ClinicianUser user = new ClinicianUser("VHAISWBOYETJ","991", 59823l );// LOCALHOST
			//ClinicianUser user = new ClinicianUser(531263l);// INTB
			ClinicianClientSession session = new ClinicianClientSession();
		
			s = System.currentTimeMillis();
			session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
			System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
			// Sending a mail to USer
//			ClinicianMessageTO clinicMessage = new ClinicianMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), 
//					false, null, 7622l, "SenderName", 7614l, "RecipientName", null, "READ", 
//					ParticipantTypeEnum.CLINICIAN, null, 10961l, ParticipantTypeEnum.CLINICIAN, null, null, null, null, null, null, null );
			
			// Sending a mail to Distribution Group
			ClinicianMessageTO clinicMessage = new ClinicianMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), 
					false, null, 7622l, "SenderName", 14653l, "RecipientName", null, "READ", 
					ParticipantTypeEnum.DISTRIBUTION_GROUP, null, 7614l, ParticipantTypeEnum.CLINICIAN, null, null, null, null, null, null, null );
			
			clinicMessage.setSelectedTriageGroupId(224489l);
			testSendMessage(prepareHeaders( session ), "application/json", "application/json", clinicMessage);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void REPLY_MESSAGE_MESSAGE() {
		long s = System.currentTimeMillis();
		ClinicianApp app = new ClinicianApp(ClientApplicationHelper.findClientApplication(101l).getAppToken());

		ClinicianUser user = new ClinicianUser("VHAISWBOYETJ","991", 59823l );// LOCALHOST
		ClinicianClientSession session = new ClinicianClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
		
		// Reply message to a Patient..
		ClinicianMessageTO clinicMessage = new ClinicianMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), 
		false, null, 7622l, "SenderName", 7614l, "RecipientName", null, "READ", 
		ParticipantTypeEnum.PATIENT, null, 10961l, ParticipantTypeEnum.CLINICIAN, null, null, null, null, null, null, null );
		
		//testReplyMessage(prepareHeaders( session ), "application/json", "application/json", clinicMessage);
		testReplyMessageWithAttachment(prepareHeaders( session ), "multipart/form-data", "application/json", clinicMessage);
		
		
		System.out.println("REPLY MESSAGE Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Reply message DONE: ");
	}

	public static void TEST_DELETE_MESSAGE() {
		try {
			long s = System.currentTimeMillis();
			ClinicianApp app = new ClinicianApp(ClientApplicationHelper.findClientApplication(101l).getAppToken());
			
			ClinicianUser user = new ClinicianUser("VHAISWBOYETJ","991", 59823l );// LOCALHOST
			//ClinicianUser user = new ClinicianUser(531263l);// INTB
			ClinicianClientSession session = new ClinicianClientSession();
		
			s = System.currentTimeMillis();
			session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
			System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());

			testDeleteMessage(prepareHeaders( session ), "application/json", "application/json");
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public static ClinicianMessageTO testReadMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType, long messageId ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/clinician/v1/message/"+messageId+"/read");
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);

			String resp = client.get(String.class);
			ObjectMapper mapper = new ObjectMapper();
			ClinicianMessageTO message2 = mapper.readValue(resp, ClinicianMessageTO.class);
			
//			//ClinicianMessageTO message2 = client.get(ClinicianMessageTO.class);
//			Response message2 = client.get();
	
			return message2;
		//	return new ClinicianMessageTO();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	public static boolean testSendMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType, ClinicianMessageTO clinicMessage ) {
		Response r = null;
	
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/clinician/v1/message", PROVIDERS);
		try {
		client.headers(headers);
		client.type(contentType).accept(acceptType);
		clinicMessage.setBody(clinicMessage.getBody()+" Houston Reporting");
		r=client.post( clinicMessage );
		//r=client.post( new ClinicianMessageTO());
		//r=client.post( new JunkTO("123") );
	} catch (Exception e) {
		e.printStackTrace();
	}
	return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testReplyMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType, ClinicianMessageTO clinicMessage ) {
		Response r = null;
		WebClient client = null;
		try {
			client = WebClient.create(HOST +"/mhv-sm-api/clinician/v1/message/225429/reply", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			clinicMessage.setBody(clinicMessage.getBody()+" Houston Replying");
			r=client.post( clinicMessage );
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			client.close();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testDeleteMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		WebClient client = null;
		try {
			//224422
			client = WebClient.create(HOST +"/mhv-sm-api/clinician/v1/message/225429", PROVIDERS);
	        client.headers(headers);
			client.type(contentType).accept(acceptType);
			client.post("");
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			client.close();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testReplyMessageWithAttachment( MultivaluedMap<String,String>headers, String contentType, String acceptType,ClinicianMessageTO clinicMessage ) {
		Response r = null;
		try {
			long startTime = System.currentTimeMillis();
			// localhost replyid: 224634; intb: 51591
			WebClient client = WebClient.create(HOST +"/mhv-sm-api/clinician/v1/message/225429/reply/attach", PROVIDERS);
			
			//Note: For INTB Testing Below...
//			r=client.post( new MessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), false, null, 
//			new Long(7614), "SenderName", new Long (51578), "RecipientName", null, "READ") );
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			List<Attachment> atts = new LinkedList<Attachment>();
//			atts.add(new Attachment("message", "application/json",  new MessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content Replying..", false, null, 
//					new Long(224345), "SenderName", new Long (224489), "RecipientName", null, "READ") ));
			atts.add(new Attachment("message", "application/json", clinicMessage));			
			ContentDisposition cd = new ContentDisposition("attachment;filename=eric_shinseki.jpg");
			atts.add(new Attachment("file", new FileInputStream(new File("eric_shinseki.jpg")), cd));
			r=client.post(new MultipartBody(atts));
			long endTime = System.currentTimeMillis();
			System.out.println("TIME TAKEN:::::: "+(endTime - startTime) +"ms");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}

	private static ClinicianClientSession testGetSession(MultivaluedMap<String, String>headers, String contentType, String acceptType ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/clinician/v1/session");
		Response r = null;
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			r = client.get();
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(r==null) {
			throw new RuntimeException("Unable to create a session");
		}
		ClinicianClientSession s=new ClinicianClientSession(r.getHeaderString("Token"),r.getHeaderString("Expires"));
		
		return s;
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( ClinicianApp app, ClinicianUser user ) {
		return prepareHeaders( app, user, null);
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( ClinicianClientSession session ) {
		return prepareHeaders( null, null, session);
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( ClinicianApp app, ClinicianUser user, ClinicianClientSession session ) {

		MultivaluedMap<String,String>headers = new MultivaluedHashMap<String, String>();
		if( null != app ) {
			headers.putSingle("appToken", app.getToken());
		}
		if( null != session ) {
			headers.putSingle("Token", session.getToken());
		}
		else if( null != user ) {
			headers.putSingle("userName", String.valueOf(user.getUserName()));
			headers.putSingle("stationNumber", String.valueOf(user.getStationNumber()));
			headers.putSingle("duz", String.valueOf(user.getDuz()));
		}
		return headers;
	}
	
}
class ClinicianUser {
//	private Long mhvCorrelationId;
	private String userName;
	private String stationNumber;
	private Long  duz;
	public ClinicianUser(String userName, String stationNumber, Long duz) {

		this.userName 			= userName;
		this.stationNumber 		= stationNumber;
		this.duz 				= duz;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getStationNumber() {
		return stationNumber;
	}
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	public Long getDuz() {
		return duz;
	}
	public void setDuz(Long duz) {
		this.duz = duz;
	}
}

class ClinicianApp {
	private String token;
	public ClinicianApp(String token) {
		this.token=token;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
}

class ClinicianClientSession {
	private String token = "Not set";
	private String expires = "Not set";
	public ClinicianClientSession(){}
	public ClinicianClientSession(String token, String expires) {
		this.token=token;
		this.expires=expires;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public String getExpires() {
		return expires;
	}
	public void setExpires(String expires) {
		this.expires = expires;
	}
	public boolean isExpired() throws Exception {
		return isExpiring(0);
	}
	public boolean isExpiring(int seconds) throws Exception {
		Date timestamp = DateUtil.parseDate(expires);
		long currentTimeinSec = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
		long timeSeconds = TimeUnit.MILLISECONDS.toSeconds(timestamp.getTime());
		if ((currentTimeinSec - timeSeconds) <= seconds) {
			return false;
		} else {
			return true;
		}
	}
	public String toString() {
		try {
			return "ClientSession: {expires="+expires+";isExpired="+isExpired()+";isExpiring(in 60 sec)="+isExpiring(60)+";token=" + token + "}";
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "Error";
	}
}

