package client;

import gov.va.med.mhv.sm.api.transfer.ErrorTO;
import gov.va.med.mhv.sm.api.transfer.FolderTO;
import gov.va.med.mhv.sm.api.transfer.FoldersTO;
import gov.va.med.mhv.sm.api.transfer.MessageTO;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;
import gov.va.med.mhv.sm.api.transfer.TriageTeamTO;
import gov.va.med.mhv.sm.api.transfer.PatientMessageTO;
import gov.va.med.mhv.sm.api.transfer.TriageTeamsTO;
import gov.va.med.mhv.sm.api.util.ClientApplicationHelper;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

import org.apache.commons.httpclient.util.DateUtil;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class TestClient {
	static String HOST="http://localhost:7001";
//	static String HOST ="http://serverserver1.domain.ext:7010";
//	static String HOST ="https://sm-intb.myhealth.domain";
//	static String HOST ="http://srv-serv.myhealth.domain";
	
	static List<Object> PROVIDERS = new ArrayList<Object>();
    static {
    	PROVIDERS.add(new org.codehaus.jackson.jaxrs.JacksonJsonProvider());
    	//HOST="http://localhost";
    	//HOST="http://serverserver1.domain.ext:7010";
    }
    
	public static void main(String[] args) {
		// SEQUENCE_TEST();
		TEST_SEND_MESSAGE();
		//REPLY_MESSAGE();
		//MESSAGE_HISTORY();
		//TEST_DELETE_MESSAGE();
//		TEST_READ_MESSAGE();
		//TEST_SAVE_SEND_DRAFT_MESSAGE();
		//TEST_READ_ATTACHMENT_MESSAGE();
	}
	
	public static void TEST_SEND_MESSAGE() {
		
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		User user = new User(2578682l);//36733l);//
//		User user = new User(495713l);//36733l); //For INTB Testing
//		User user = new User(531263l); //INTB JANE
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		s = System.currentTimeMillis();
	
		testPostMessage(prepareHeaders( session ), "application/json", "application/json");
		
		System.out.println("SEND MESSAGE Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Send message DONE: ");	
	}
	public static void REPLY_MESSAGE() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
//		User user = new User(2578682l);//36733l);//
//		User user = new User(495713l);//36733l); //For INTB Testing
		User user = new User(531263l); //INTB JANE
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		s = System.currentTimeMillis();
		//testReplyMessage(prepareHeaders( session ), "application/json", "application/json");
		testReplyMessageWithAttachment(prepareHeaders( session ), "multipart/form-data", "application/json");
		
		
		System.out.println("REPLY MESSAGE Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Reply message DONE: ");
	}
	public static void MESSAGE_HISTORY() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		//495713l - intb user
		User user = new User(2578682l);//36733l);//
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		//s = System.currentTimeMillis();
		//testReplyMessage(prepareHeaders( session ), "application/json", "application/json");
		//testReplyMessageWithAttachment(prepareHeaders( session ), "multipart/mixed", "application/json");
		testMessageHistory(prepareHeaders( session ), "application/json", "application/json");
		
		//testReplyMessage(session, "application/json", "application/json");
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Reply message DONE: ");
	
	}
	
	public static void TEST_DELETE_MESSAGE() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		//495713l - intb user
		User user = new User(2578682l);//36733l);//
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		//s = System.currentTimeMillis();
		//testReplyMessage(prepareHeaders( session ), "application/json", "application/json");
		//testReplyMessageWithAttachment(prepareHeaders( session ), "multipart/mixed", "application/json");
		testDeleteMessage(prepareHeaders( session ), "application/json", "application/json");
		
		//testReplyMessage(session, "application/json", "application/json");
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Reply message DONE: ");
	}
	public static void TEST_READ_MESSAGE() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		//495713l - intb user
		User user = new User(2578682l); //LOCALHOST
		//User user = new User(531263l);// INTB
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		MessageTO msg = testReadMessage2(prepareHeaders( session ), "application/json", "application/json", 53711l);
		//testReplyMessage(session, "application/json", "application/json");
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("READ message DONE: " +msg.getBody());
	}
	public static void TEST_READ_ATTACHMENT_MESSAGE() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		//495713l - intb user
		//User user = new User(2578682l);LOCALHOST
		User user = new User(531263l);// INTB
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		testGetAttachment(prepareHeaders( session ), "application/json", "application/octet-stream");
		
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		
	}
	
	public static void TEST_SAVE_SEND_DRAFT_MESSAGE() {
		long s = System.currentTimeMillis();
		App app = new App(ClientApplicationHelper.findClientApplication(100l).getAppToken());
		//495713l - intb user
		//User user = new User(2578682l);LOCALHOST
		User user = new User(531263l);// INTB
		ClientSession session = new ClientSession();
	
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
	
		testPostSendDraftMessage(prepareHeaders( session ), "application/json", "application/json", 53725l);
		//testReplyMessage(session, "application/json", "application/json");
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
	}
	

	public static MessageTO testReadMessage2( MultivaluedMap<String,String>headers, String contentType, String acceptType, long messageId ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/"+messageId+"/read");
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);

			String resp = client.get(String.class);
			ObjectMapper mapper = new ObjectMapper();
			MessageTO message2 = mapper.readValue(resp, MessageTO.class);
			
			return message2;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	
	public static void SEQUENCE_TEST() {
		long s = System.currentTimeMillis();
		App app = new App("qhEH6XJucS-PO5VxDQvjK");
		User user = new User(495713l);//36733l);//
		ClientSession session = new ClientSession();
		
		s = System.currentTimeMillis();
		session= testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println("testGetSession  Took: " + (System.currentTimeMillis()-s) +" ms " + session.getExpires() + " " +session.getToken());
		
		//testGetAttachment( prepareHeaders( session ), "application/json", "application/octet-stream" );
		
		try {
			if( !session.isExpired() ) {		
				if (! testPostMessageWithAttachment( prepareHeaders( session ), "multipart/mixed", "application/json" )) {
					System.err.println("Failed testPostMessageWithAttachment");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		System.exit(0);
		
		
		s = System.currentTimeMillis();
		FoldersTO folders = testGetFoldersTO( prepareHeaders( session ), "application/json", "application/json" );
		System.out.println("testGetFoldersTO Took: " + (System.currentTimeMillis()-s) +" ms");
		
		long mid = 0;
		for(int i = 0; i<3;i++) {
			s = System.currentTimeMillis();
			List<MessageTO>msgs = testGetMessagesListForFolder( prepareHeaders( session ), "application/json", "application/json", 0, i, 20 ); //0 - inbox, -1 - sent
			System.out.println("->testGetMessagesForFolder Took: " + (System.currentTimeMillis()-s) +" ms");
			System.out.println("->RETURNED: " + msgs.size() +" ELEMENTS.");
			for( MessageTO m:msgs) {
				System.out.println(m);
				mid = m.getId();
			}
		}
		
		s = System.currentTimeMillis();
		MessageTO msg = testReadMessage(prepareHeaders( session ), "application/json", "application/json" , 409042);
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Read message: " + msg);

		s = System.currentTimeMillis();
		testGetCategoryList( prepareHeaders( session ),  "application/json", "application/json");
		System.out.println("testGetCategoryList Took: " + (System.currentTimeMillis()-s) +" ms");
		
		s = System.currentTimeMillis();
		testPostMessage(prepareHeaders( session ), "application/json", "application/json" );
		System.out.println("testPostMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		
		System.exit(0);
		
		//** SEND DRAFT PASS
//		try {
//			if( !session.isExpired() ) {		
//				if (! testPostSendDraftMessage( prepareHeaders( session ), "application/json", "application/json", mid)) {
//					System.err.println("Failed testPostSendDraftMessage");
//				}
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
		
//		try {
//			if( !session.isExpired() ) {		
//				if (! testPostDraftMessage( prepareHeaders( session ), "application/json", "application/json" )) {
//					System.err.println("Failed testPostDraftMessage");
//				}
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
		
		
		
		/**
		 * TEST DELETE A FOLDER  (PASSED)
		 */
//		s = System.currentTimeMillis();
//		boolean b = testDeleteFolder(prepareHeaders( session ), "application/json", "application/json" , 37636);
//		System.out.println("testDeleteFolder Took: " + (System.currentTimeMillis()-s) +" ms");
//		System.out.println("Delete folder: " + b);
//		System.exit(0);
		
		
		/**
		 * TEST CREATE A FOLDER  (PASSED)
		 */
		s = System.currentTimeMillis();
		FolderTO newf = testCreateFolder(prepareHeaders( session ), "application/json", "application/json" , new FolderTO(0,"Third API Folder that is surely greater than thirty characters because I really tried hard",0,0));
		System.out.println("testCreateFolder Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Newly created folder: " + newf);
		
		s = System.currentTimeMillis();
		msg = testReadMessage(prepareHeaders( session ), "application/json", "application/json" , 41042);
		System.out.println("testReadMessage Took: " + (System.currentTimeMillis()-s) +" ms");
		System.out.println("Read message: " + msg);
		System.exit(0);
		
		
//		s = System.currentTimeMillis();
//		testMoveMessageToFolder( prepareHeaders( session ), "application/json", "application/json", 41042, 37635 );
//		System.out.println("testMoveMessageToFolder Took: " + (System.currentTimeMillis()-s) +" ms");
//		System.exit(0);
		
		s = System.currentTimeMillis();
		List<TriageTeamTO>teams = testGetTraigeTeams( prepareHeaders( session ), "application/json", "application/json" );
		System.out.println("testGetTraigeTeams Took: " + (System.currentTimeMillis()-s) +" ms");
		
		
		for(int i = 0; i<1;i++) {
			s = System.currentTimeMillis();
			List<MessageTO>msgs = testGetMessagesListForFolder( prepareHeaders( session ), "application/json", "application/json", 37635, i, 20 ); //0 - inbox, -1 - sent
			System.out.println("->testGetMessagesForFolder Took: " + (System.currentTimeMillis()-s) +" ms");
			System.out.println("->RETURNED: " + msgs.size() +" ELEMENTS.");
			for( MessageTO m:msgs) {
				System.out.println(m);
			}
		}
		
		for(int i = 0; i<3;i++) {
			s = System.currentTimeMillis();
			List<MessageTO>msgs = testGetMessagesListForFolder( prepareHeaders( session ), "application/json", "application/json", 0, i, 20 ); //0 - inbox, -1 - sent
			System.out.println("->testGetMessagesForFolder Took: " + (System.currentTimeMillis()-s) +" ms");
			System.out.println("->RETURNED: " + msgs.size() +" ELEMENTS.");
			for( MessageTO m:msgs) {
				System.out.println(m);
			}
		}
		System.exit(0);
		
		Map<FolderTO,MessagesTO> cache = new HashMap<FolderTO,MessagesTO>();
		for( FolderTO folder : folders.getFolder()) {
			s = System.currentTimeMillis();
			try {
				if( folder.getCount() > 0)
					cache.put(folder, testGetMessagesTOForFolder( prepareHeaders( session ), "application/json", "application/json", folder.getId(), 0, folder.getCount()+10 ));
			} catch(Exception e) {
				e.printStackTrace();
			}
			System.out.println("testGetMessagesTOForFolder("+folder.getName()+") Took: " + (System.currentTimeMillis()-s) +" ms");
		}
		for( FolderTO f:cache.keySet() ) {
			System.out.println("Folder: " + f.getName() + " (" + f.getCount() +")");
			MessagesTO messages = cache.get(f);
			System.out.println("   - Messages cached " + messages.getMessage().size());
		}
	}
	
	public static void MULTIPLE_TESTS() {
		App app = new App(ClientApplicationHelper.findClientApplication(1l).getAppToken());
		//User user = new User(39045l);
		User user = new User(7614l); //DEV/LOCAL

		ClientSession session = testGetSession( prepareHeaders( app, user ), "application/json", "application/json");
		System.out.println(session);

		try {
			if( !session.isExpired() ) {
				
				List<MessageTO>messages;
				for(int i = 0; i<10;i++) {
					long s = System.currentTimeMillis();
					messages = testGetMessagesListForFolder( prepareHeaders( session ), "application/json", "application/json", 0, i, 50 ); //0 - inbox, -1 - sent
					System.out.println("testGetMessagesForFolder Took: " + (System.currentTimeMillis()-s) +" ms");
					System.out.println("RETURNED: " + messages.size() +" ELEMENTS.");
					for( MessageTO m: messages ) {
						System.out.println(m);
					}
				}
				
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			if( !session.isExpired() ) {
				long s = System.currentTimeMillis();
				List<TriageTeamTO>teams = testGetTraigeTeams( prepareHeaders( session ), "application/json", "application/json" );
				System.out.println("testGetTraigeTeams Took: " + (System.currentTimeMillis()-s) +" ms");
				for( TriageTeamTO team: teams ) {
					System.out.println("TriageTeamTO {id="+team.getTriageTeamId()+";name="+team.getName()+"}");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			if( !session.isExpired() ) {
				long s = System.currentTimeMillis();
				List<FolderTO> folders = testGetListOfFolders( prepareHeaders( session ), "application/json", "application/json" );
				System.out.println("testGetFolders Took: " + (System.currentTimeMillis()-s) +" ms");
				for( FolderTO f: folders ) {
					System.out.println(f);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
//		try {
//			if( !session.isExpired() ) {
//				for(int loop = 0; loop < 5; loop++) {
//					long s = System.currentTimeMillis();
//					FolderTO f = testGetFolder( prepareHeaders( session ), "application/json", "application/json", 0 );
//					System.out.println("testGetFolder Took: " + (System.currentTimeMillis()-s) +" ms");
//					System.out.println("Folder {id="+f.getFolderId()+";name="+f.getFolderName()+"}");
//				}
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
		
		try {
			if( !session.isExpired() ) {
				long s = System.currentTimeMillis();
				MessageTO m = testReadMessage( prepareHeaders( session ), "application/json", "application/json", 45708 );
				System.out.println("testGetMessage Took: " + (System.currentTimeMillis()-s) +" ms");
				System.out.println(m);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		System.exit(0);

		try {
			if( !session.isExpired() ) {		
				if (! testPostMessageWithAttachment( prepareHeaders( session ), "multipart/mixed", "application/json" )) {
					System.err.println("Failed testPostMessageWithAttachment");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		try {
			if( !session.isExpired() ) {		
				if (! testPostMessage( prepareHeaders( session ), "application/json", "application/json" )) {
					System.err.println("Failed testPostMessage");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		try {
			if( !session.isExpired() ) {		
				if (! testGetAttachment( prepareHeaders( session ), "application/json", "multipart/mixed" )) {
					System.err.println("Failed testGetAttachment");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	private static ClientSession testGetSession(MultivaluedMap<String, String>headers, String contentType, String acceptType ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/session");
		Response r = null;
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			r = client.get();
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(r==null) {
			throw new RuntimeException("Unable to create a session");
		}
		ClientSession s=new ClientSession(r.getHeaderString("Token"),r.getHeaderString("Expires"));
		
		return s;
	}
	
	public static boolean testGetCategoryList( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/category");
		Response r = null;
		
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			String resp = client.get(String.class);
			System.out.println("testGetCategory: " + resp);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testGetAttachment( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {

        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/51112/attachment/51110");
        Response r = null;

        try {
              client.headers(headers);
//              client.type(contentType).accept(acceptType);

              r = client.get();
              if( r.getStatus() == 200 ) {

                    byte file[] = client.get(byte[].class);
                    FileOutputStream fos = new FileOutputStream(new File("E:/result.jpg"));
                    fos.write(file);
                    fos.close();
              } else {
            	  ErrorTO resp = client.get(ErrorTO.class);
                    System.out.println("testGetCategory: " + resp);
              }

        } catch (Exception e) {

              e.printStackTrace();

        }

        return (r==null?false:r.getStatus()==200);

  }


	public static void testMoveMessageToFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, long messageId, long folderId ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/"+messageId+"/move/tofolder/"+folderId);
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			Response r = client.post("");
			System.out.println("testMoveMessageToFolder : " + r.getStatus());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static MessageTO testReadMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType, long messageId ) {
		WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/"+messageId+"/read");
		try {
			client.headers(headers);
			client.type(contentType).accept(acceptType);

			String resp = client.get(String.class);
			ObjectMapper mapper = new ObjectMapper();
			MessageTO message2 = mapper.readValue(resp, MessageTO.class);
			
			return message2;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	public static List<TriageTeamTO> testGetTraigeTeams( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/triageteam", PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		TriageTeamsTO list = client.get(TriageTeamsTO.class);
		return list.getTriageTeam();
	}
	
	public static List<FolderTO> testGetListOfFolders( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder", PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		FoldersTO list = client.get(FoldersTO.class);
		return list.getFolder();
	}
	
	public static FoldersTO testGetFoldersTO( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder", PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		FoldersTO foldersTO = client.get(FoldersTO.class);
		return foldersTO;
	}
	
	public static FolderTO testCreateFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, FolderTO newFolder) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder", PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		ObjectMapper mapper = new ObjectMapper();
		Response r = null;
		try {
			r = client.post(mapper.writeValueAsString(newFolder));
		} catch (JsonGenerationException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return r.readEntity(FolderTO.class);
	}
	
	public static boolean testDeleteFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, int folderId ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder/"+folderId, PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		Response r = client.delete();
		return r.getStatus()==200;
	}
	
	public static FolderTO testGetFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, int folderId ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder/"+folderId, PROVIDERS); 
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		FolderTO folder = client.get(FolderTO.class);
		return folder;
	}
	
	public static List<MessageTO> testGetMessagesListForFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, int folderId, int page, int pageSize ) {
        //WebClient client = WebClient.create("http://localhost:14368/mhv-sm-api/patient/v1/folder/"+folderId+"/message/page/"+page+"/pageSize/"+pageSize, PROVIDERS);
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder/"+folderId+"/message/page/"+page+"/pageSize/"+pageSize, PROVIDERS);
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		MessagesTO list = client.get(MessagesTO.class);
		return list.getMessage();
	}
	
	public static MessagesTO testGetMessagesTOForFolder( MultivaluedMap<String,String>headers, String contentType, String acceptType, long folderId, long page, long pageSize ) {
        WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/folder/"+folderId+"/message/page/"+page+"/pageSize/"+pageSize, PROVIDERS);
        client.headers(headers);
		client.type(contentType).accept(acceptType);
		MessagesTO list = client.get(MessagesTO.class);
		return list;
	}
	
	public static boolean testPostMessageWithAttachment( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		try {
			WebClient client = WebClient.create("http://localhost:80/mhv-sm-api/patient/v1/message/attach", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			List<Attachment> atts = new LinkedList<Attachment>();
			atts.add(new Attachment("message", "application/json", getJsonMessage()));
			ContentDisposition cd = new ContentDisposition("attachment;filename=triangleicon.jpg");
			atts.add(new Attachment("file", new FileInputStream(new File("triangleicon.jpg")), cd));
			r=client.post(new MultipartBody(atts));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testPostMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		try {
			WebClient client = WebClient.create(HOST + "/mhv-sm-api/patient/v1/message", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			r=client.post( getJsonMessage() );
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testReplyMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		WebClient client = null;
		try {
			client = WebClient.create(HOST +"/mhv-sm-api/patient/v1/message/224869/reply", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			r=client.post( new PatientMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), false, null, 
								new Long(7614), "SenderName", new Long (224489), "RecipientName", null, "READ") );
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			client.close();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	
	public static boolean testReplyMessageWithAttachment( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		try {
			long startTime = System.currentTimeMillis();
			// localhost replyid: 224634; intb: 51591
			WebClient client = WebClient.create(HOST +"/mhv-sm-api/patient/v1/message/53313/reply/attach", PROVIDERS);
			
			//Note: For INTB Testing Below...
//			r=client.post( new MessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content T"+System.currentTimeMillis(), false, null, 
//			new Long(7614), "SenderName", new Long (51578), "RecipientName", null, "READ") );
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			List<Attachment> atts = new LinkedList<Attachment>();
//			atts.add(new Attachment("message", "application/json",  new MessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Body content Replying..", false, null, 
//					new Long(224345), "SenderName", new Long (224489), "RecipientName", null, "READ") ));
			atts.add(new Attachment("message", "application/json",  new PatientMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Subject content", "Replying by Khan Java Client..", false, null, 
			new Long(7614), "SenderName", new Long (51578), "RecipientName", null, "READ") ));			
			ContentDisposition cd = new ContentDisposition("attachment;filename=eric_shinseki.jpg");
			atts.add(new Attachment("file", new FileInputStream(new File("anthony_principi.jpg")), cd));
			r=client.post(new MultipartBody(atts));
			long endTime = System.currentTimeMillis();
			System.out.println("TIME TAKEN:::::: "+(endTime - startTime) +"ms");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testMessageHistory( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		WebClient client = null;
		try {
			//224422
			client = WebClient.create(HOST +"/mhv-sm-api/patient/v1/message/224348/history", PROVIDERS);
	        client.headers(headers);
			client.type(contentType).accept(acceptType);
			MessagesTO list = client.get(MessagesTO.class);
			List<MessageTO> lt = list.getMessage();
			Iterator<MessageTO> it = lt.iterator();
			while (it.hasNext()) {
				System.out.println(it.next().getBody());
			}
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			client.close();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testDeleteMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		WebClient client = null;
		try {
			//224422
			client = WebClient.create(HOST +"/mhv-sm-api/patient/v1/message/224479", PROVIDERS);
	        client.headers(headers);
			client.type(contentType).accept(acceptType);
			client.post("");
			
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		finally {
			client.close();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	
	public static boolean testPostSendDraftMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType, long draftMessageId) {
		Response r = null;
		try {
			WebClient client = WebClient.create(HOST+"/mhv-sm-api/patient/v1/message/"+draftMessageId+"/sendDraft", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			r=client.post("");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}
	
	public static boolean testPostDraftMessage( MultivaluedMap<String,String>headers, String contentType, String acceptType ) {
		Response r = null;
		try {
			WebClient client = WebClient.create("http://localhost:14368/mhv-sm-api/patient/v1/message/draft", PROVIDERS);
			client.headers(headers);
			client.type(contentType).accept(acceptType);
			MessageTO msg = getJsonMessage();
			msg.setBody(msg.getBody()+" DRAFT");
			r=client.post( msg );
		} catch (Exception e) {
			e.printStackTrace();
		}
		return (r==null?false:r.getStatus()==200);
	}

	public static MessageTO getJsonMessage() {
		return new PatientMessageTO(0l,MessageCategoryTypeEnum.OTHER, "Test Surrogate", "Body content T "+System.currentTimeMillis(), false, null, 7614l, "SenderName", 224489l, "RecipientName", null, "READ"); //local db 20364
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( App app, User user ) {
		return prepareHeaders( app, user, null);
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( ClientSession session ) {
		return prepareHeaders( null, null, session);
	}
	
	public static MultivaluedMap<String,String> prepareHeaders( App app, User user, ClientSession session ) {
		MultivaluedMap<String,String>headers = new MultivaluedHashMap<String, String>();
		if( null != app ) {
			headers.putSingle("appToken", app.getToken());
		}
		if( null != session ) {
			headers.putSingle("Token", session.getToken());
		}
		else if( null != user ) {
			headers.putSingle("mhvCorrelationId", String.valueOf(user.getMhvCorrelationId()));
		}
		return headers;
	}

}

class User {
	private Long mhvCorrelationId;
	public User(Long mhvCorrelationId) {
		this.mhvCorrelationId = mhvCorrelationId;
	}
	public Long getMhvCorrelationId() {
		return mhvCorrelationId;
	}
	public void setMhvCorrelationId(Long mhvCorrelationId) {
		this.mhvCorrelationId = mhvCorrelationId;
	}
}

class App {
	private String token;
	public App(String token) {
		this.token=token;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
}

class ClientSession {
	private String token = "Not set";
	private String expires = "Not set";
	public ClientSession(){}
	public ClientSession(String token, String expires) {
		this.token=token;
		this.expires=expires;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public String getExpires() {
		return expires;
	}
	public void setExpires(String expires) {
		this.expires = expires;
	}
	public boolean isExpired() throws Exception {
		return isExpiring(0);
	}
	public boolean isExpiring(int seconds) throws Exception {
		Date timestamp = DateUtil.parseDate(expires);
		long currentTimeinSec = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
		long timeSeconds = TimeUnit.MILLISECONDS.toSeconds(timestamp.getTime());
		if ((currentTimeinSec - timeSeconds) <= seconds) {
			return false;
		} else {
			return true;
		}
	}
	public String toString() {
		try {
			return "ClientSession: {expires="+expires+";isExpired="+isExpired()+";isExpiring(in 60 sec)="+isExpiring(60)+";token=" + token + "}";
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "Error";
	}
}