package gov.va.med.mhv.sm.api.util;

import gov.va.med.mhv.foundation.util.ConfigurationManager;

import java.io.File;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertiesHelper {
	private static final Log log = LogFactory.getLog(PropertiesHelper.class);
	private static final String PROPERTIES_FILE_NAME = File.separator + "sm-api.properties";
	private static Properties properties;

	static {
		loadProperties();
	}

	public static String getFileName() {
		return PROPERTIES_FILE_NAME;
	}

	private static void loadProperties() {

		//System.setProperty("config.location", "C:\\data\\bea1035\\wlserver_10.3\\sm_config");
		//System.setProperty("config.location", "E:\\bea\\10.3.2\\wlserver_10.3\\mhv_config\\");

		Properties props = ConfigurationManager.getConfiguration(PROPERTIES_FILE_NAME);
		if (props == null) {
			log.error("Could not load properties file: " + PROPERTIES_FILE_NAME);
		} else {
			properties = props;
		}
	}

	public static Properties getProperties() {
		if(properties !=null)
			return properties;
		else {
			loadProperties();
			return properties;
		}
	}

}
