package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.enumeration.ClinicianStatusEnum;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.httpclient.util.DateUtil;

@XmlRootElement(name = "Message")
public class ClinicianMessageTO extends MessageTO implements Serializable {
	public static final long serialVersionUID = -5445747007234726972L;
	
	private ParticipantTypeEnum recipientType;
	private String ccRecipientName;
	private Long ccRecipientId;
	private ParticipantTypeEnum ccRecipientType;
	private InformationMessagesTO informationMessages;
	private Long selectedTriageGroupId; 
	
	private Date escalatedDate;
	private Date completedDate;
	private ClinicianUserTO assignedTo;
	private Boolean isEscalated;
	private ClinicianStatusEnum status;
	private Date reminderDate;
	
	public ClinicianMessageTO() {
		super();
	}
		
	/**
	 * @param id
	 * @param category
	 * @param subject
	 * @param body
	 * @param attachment
	 * @param attachments
	 * @param senderId
	 * @param senderName
	 * @param recipientId
	 * @param recipientName
	 * @param sentDate
	 * @param readReceipt
	 * @param recipientType
	 * @param ccRecipientName
	 * @param ccRecipientId
	 * @param ccRecipientType
	 * @param informationMessage
	 * @param escalatedDate
	 * @param completedDate
	 * @param assignedTo
	 * @param isEscalated
	 */
	public ClinicianMessageTO(long id, MessageCategoryTypeEnum category, String subject, String body, 
			boolean attachment, AttachmentsTO attachments, Long senderId, String senderName, 
			Long recipientId, String recipientName, Date sentDate, String readReceipt, 
			ParticipantTypeEnum recipientType, String ccRecipientName, Long ccRecipientId, ParticipantTypeEnum ccRecipientType,
			List<String> informationMessages, Date escalatedDate, Date completedDate, ClinicianUserTO assignedTo, Boolean isEscalated,
			ClinicianStatusEnum status, Date reminderDate, Long selectedTriageGrpId) {
		super(id, category, subject, body, attachment, attachments, senderId, senderName, 
			  recipientId, recipientName, sentDate, readReceipt);
		this.ccRecipientName = ccRecipientName;
		this.ccRecipientType = ccRecipientType;
		this.ccRecipientId = ccRecipientId;
		this.recipientType = recipientType;
		this.informationMessages = new InformationMessagesTO(informationMessages);
		this.escalatedDate = escalatedDate;
		this.completedDate = completedDate;
		this.assignedTo = assignedTo;
		this.isEscalated = isEscalated;
		this.reminderDate = reminderDate;
		this.status = status;
		this.selectedTriageGroupId = selectedTriageGrpId;
	}

	public String getCcRecipientName() {
		return ccRecipientName;
	}
	public void setCcRecipientName(String ccRecipientName) {
		this.ccRecipientName = ccRecipientName;
	}
	public Long getCcRecipientId() {
		return ccRecipientId;
	}
	public void setCcRecipientId(Long ccRecipientId) {
		this.ccRecipientId = ccRecipientId;
	}
	public ParticipantTypeEnum getRecipientType() {
		return recipientType;
	}
	public void setRecipientType(ParticipantTypeEnum recipientType) {
		this.recipientType = recipientType;
	}
	public ParticipantTypeEnum getCcRecipientType() {
		return ccRecipientType;
	}
	public void setCcRecipientType(ParticipantTypeEnum ccRecipientType) {
		this.ccRecipientType = ccRecipientType;
	}
	public InformationMessagesTO getInformationMessages() {
		return informationMessages;
	}
	public void setInformationMessages(InformationMessagesTO informationMessages) {
		this.informationMessages = informationMessages;
	}
	public Long getSelectedTriageGroupId() {
		return selectedTriageGroupId;
	}
	public void setSelectedTriageGroupId(Long selectedTriageGroupId) {
		this.selectedTriageGroupId = selectedTriageGroupId;
	}
	public String getEscalatedDate() {
		return (escalatedDate!=null?DateUtil.formatDate(escalatedDate):"");
	}
	public void setEscalatedDate(Date escalatedDate) {
		this.escalatedDate = escalatedDate;
	}
	public String getCompletedDate() {
		return (completedDate!=null?DateUtil.formatDate(completedDate):"");
	}
	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}
	public ClinicianUserTO getAssignedTo() {
		return assignedTo;
	}
	public void setAssignedTo(ClinicianUserTO assignedTo) {
		this.assignedTo = assignedTo;
	}
	public Boolean getIsEscalated() {
		return isEscalated;
	}
	public void setIsEscalated(Boolean isEscalated) {
		this.isEscalated = isEscalated;
	}
	public ClinicianStatusEnum getStatus() {
		return status;
	}
	public void setStatus(ClinicianStatusEnum status) {
		this.status = status;
	}
	public String getReminderDate() {
		return (reminderDate!=null?DateUtil.formatDate(reminderDate):"");
	}
	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}
	
}
