package gov.va.med.mhv.sm.api.patient.impl;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.api.common.SessionAPIService;
import gov.va.med.mhv.sm.api.enumeration.ErrorEnum;
import gov.va.med.mhv.sm.api.patient.TriageTeamAPIService;
import gov.va.med.mhv.sm.api.transfer.PatientTriageTeamTO;
import gov.va.med.mhv.sm.api.transfer.Session;
import gov.va.med.mhv.sm.api.transfer.TriageTeamTO;
import gov.va.med.mhv.sm.api.transfer.TriageTeamsTO;
import gov.va.med.mhv.sm.api.util.SMApiUtility;
import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TriageRelation;
import gov.va.med.mhv.sm.service.TriageGroupService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.apache.cxf.jaxrs.ext.MessageContext;

public class TriageTeamAPIServiceImpl implements TriageTeamAPIService {
	private SessionAPIService sessionApiService;
	private TriageGroupService triageGroupService;
	
	@Resource
	MessageContext mc;

	/**
	 * 0	33763  (PRIMARY_PROVIDER)
	 * 1	182141 (CLINIC)
	 * 2	1516   (TEAM)
	 * 6	40543  (PATIENT)
	 * 
	 * Session Error Codes: 108, 109, 110, 111
	 * Service Error Codes: 902
	 */
	@Override
	public TriageTeamsTO getTriageTeams() {
		Session session = sessionApiService.checkSession(mc);
		
		Patient p = (Patient)session.getPatient();
		
		CollectionServiceResponse<TriageRelation> response = triageGroupService.getRelationsForPatient(p);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response);
		Collection<TriageRelation> list = response.getCollection();
		
		List<TriageTeamTO> triageTeamArray = new ArrayList<TriageTeamTO>();
		for(TriageRelation tr : list) {	
			triageTeamArray.add(new PatientTriageTeamTO(tr.getTriageGroup().getId(),tr.getTriageGroup().getName(), tr.getRelationType()));
		}
		
		return new TriageTeamsTO(triageTeamArray); 
	}

	public SessionAPIService getSessionApiService() {
		return sessionApiService;
	}
	public void setSessionApiService(SessionAPIService sessionService) {
		this.sessionApiService = sessionService;
	}
	public TriageGroupService getTriageGroupService() {
		return triageGroupService;
	}
	public void setTriageGroupService(TriageGroupService triageGroupService) {
		this.triageGroupService = triageGroupService;
	}
	
}
