package gov.va.med.mhv.sm.api.patient.impl;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.api.common.SessionAPIService;
import gov.va.med.mhv.sm.api.enumeration.ErrorEnum;
import gov.va.med.mhv.sm.api.patient.MessageAPIService;
import gov.va.med.mhv.sm.api.transfer.AttachmentTO;
import gov.va.med.mhv.sm.api.transfer.AttachmentsTO;

import gov.va.med.mhv.sm.api.transfer.MessageCategoryTypesTO;
import gov.va.med.mhv.sm.api.transfer.MessageTO;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;
import gov.va.med.mhv.sm.api.transfer.PatientMessageTO;
import gov.va.med.mhv.sm.api.transfer.Session;
import gov.va.med.mhv.sm.api.util.PropertiesHelper;
import gov.va.med.mhv.sm.api.util.SMApiUtility;
import gov.va.med.mhv.sm.enumeration.MessageCategoryTypeEnum;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessageAttachment;
import gov.va.med.mhv.sm.model.NewMessage;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.Thread;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.SendMessageService;
import gov.va.med.mhv.sm.service.ThreadService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.ws.rs.core.Response;

import org.apache.axis.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

public class MessageAPIServiceImpl implements MessageAPIService {
	private static final Log log = LogFactory.getLog(MessageAPIServiceImpl.class);
	
	private SessionAPIService sessionApiService;
	private MessageService messageService;
	private SendMessageService sendMessageService;
	private TriageGroupService triageGroupService;
	private MailboxService mailboxService;
	private ThreadService threadService;
	private UserManagementService userManagementService;
	

	private static Map<String,Boolean> supportedFileTypes = new HashMap<String, Boolean>();
	private static int FILE_SIZE_LIMIT_3MB = 3 * 1024 * 1024;
	private static List<MessageCategoryTypeEnum> messageCategoryTypeEnumList;
	private static int EXPIRATION_PERIOD_IN_DAYS = -120;
	private static final String SM_WEB_PATIENT_REPLY_EXP_PARAM = "sm.web.patient.reply.expiration";
	
	@Resource
	MessageContext mc;

	static {
		if( PropertiesHelper.getProperties() != null && PropertiesHelper.getProperties().containsKey("sm.web.patient.fileupload.allowedTypes")) {
			String expStr = PropertiesHelper.getProperties().getProperty("sm.web.patient.fileupload.allowedTypes");
			String exts[] = expStr.split( ",\\s*" );
			for( String ext:exts ) {
				supportedFileTypes.put(ext.toUpperCase(), Boolean.TRUE);
			}
		}
		if( PropertiesHelper.getProperties() != null && PropertiesHelper.getProperties().containsKey(SM_WEB_PATIENT_REPLY_EXP_PARAM)) 
		{
			String expStr = PropertiesHelper.getProperties().getProperty(SM_WEB_PATIENT_REPLY_EXP_PARAM);
			try {
				int expInt = Integer.parseInt(expStr);
				if( expInt < 0 ) {
					EXPIRATION_PERIOD_IN_DAYS = expInt;
				}
			} catch (NumberFormatException e) {
				//do nothing
			}
		}
		
		messageCategoryTypeEnumList = MessageCategoryTypeEnum.toList();
	}

	private boolean isMessageExpired(Message currentMessage) {
		Date myDate = currentMessage.getCreatedDate();
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DAY_OF_MONTH, EXPIRATION_PERIOD_IN_DAYS);
		Date expiration = c.getTime();

		if (expiration.compareTo(myDate) < 0) {
			//Not expired
			return false;
		}
		else {
			//Expired
			return true;
		}
	}

	/**
	 * Session Error Codes:  108, 109, 110, 111, 112, 115
	 * Error Codes:  904
	 */
	@Override
	public PatientMessageTO readMessage(Long messageId) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		Long currentFolderId = null;

		PatientMessageTO messageTO = null;

		ServiceResponse<Message> response = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
		Message m = response.getPayload();

		if ( null != m ) {
//			if( m.getSenderId().equals(p.getId()) || m.getRecipientId().equals(p.getId()) ) {

				//For DRAFT/SENT do not modify
				for(Addressee addr:m.getAddressees()) {
					if( addr.getOwner().getId().equals(p.getId()) ) {
						currentFolderId = addr.getFolderId();
						break;
					}
				}
				if( currentFolderId == null ) {
					SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
				}			
				
				//ONLY UPDATE THE READ RECEIPT IF THE MESSAGE IS NOT ALREADY SET
				if( null == m.getReadReceipt() ) { //|| !m.getReadReceipt().equals("READ") ) {
					//Note: Message Service will return an error if the user is not the recipient of the message
					
					//ONLY MARK MESSAGE AS READ IF THE FOLDER IS NOT SENT/DRAFT
					if( ! currentFolderId.equals(SystemFolderEnum.SENT.getId()) && !currentFolderId.equals(SystemFolderEnum.DRAFTS.getId()) ){
						//MARK MESSAGE AS READ
						ServiceResponse<Message> response4 = messageService.readMessage(m,p);
						SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response4);
						response4.getPayload();
						//UPDATE THE READ RECEIPT
						ServiceResponse<Message> response5 = messageService.updateReadReceipt(messageId);
						SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response5);
						response5.getPayload();
					}
					
					ServiceResponse<Message> response6 = messageService.fetchMessage(messageId);
					SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response6);
					m = response6.getPayload();
				}

				List<AttachmentTO> attList = new ArrayList<AttachmentTO>();
				if ( null != m.getAttachmentId() ){
					ServiceResponse<MessageAttachment> response2 = messageService.fetchAttachment(m.getAttachmentId());
					SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response2);
					MessageAttachment ma = response2.getPayload();
					if(ma!=null){
						attList.add(new AttachmentTO(ma.getId(),ma.getAttachmentName()));
					}
				}

				//IF DRAFT OR SENT FOLDER REVERSE THE SENDER/RECEIVER
				if( ! currentFolderId.equals(SystemFolderEnum.SENT.getId()) && !currentFolderId.equals(SystemFolderEnum.DRAFTS.getId()) ){
					messageTO = new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), m.getThread().getSubject(), 
							m.getBody(), m.isAttachment(), new AttachmentsTO(attList), m.getRecipientId(), m.getRecipientName(), 
							m.getSenderId(), m.getSenderName(), m.getSentDate(), m.getReadReceipt());
				} else {
					//FLIP SENDER+RECEIVER
					messageTO = new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), m.getThread().getSubject(), 
						m.getBody(), m.isAttachment(), new AttachmentsTO(attList), m.getSenderId(), m.getSenderName(), 
						m.getRecipientId(), m.getRecipientName(), m.getSentDate(), m.getReadReceipt());
				}
//			}
//			else {
//				SMApiUtility.throwException(ErrorEnum.NOT_OWNER_OF_ENTITY_112);
//			}
		} else {
			SMApiUtility.throwException(ErrorEnum.NOT_FOUND_115);
		}

		return messageTO;
	}

	/**
	 * Session Error Codes: 108, 109, 110, 111
	 * Error Codes: 100, 904, 903, 902
	 */
	@Override
	public PatientMessageTO sendMessage(PatientMessageTO message) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		return sendMessage(message, p, null);
	}

	/**
	 * Session Error Codes: 108, 109, 110, 111
	 * Error Codes: 100, 113, 119, 904, 903, 902, 122, 123, 124
	 */
	@Override
	public PatientMessageTO sendMessageWithAttachment(PatientMessageTO message, final List<Attachment> rawAttachments) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		return sendMessage(message, p, rawAttachments);
	}

	private PatientMessageTO sendMessage(PatientMessageTO message, Patient p, final List<Attachment> rawAttachments) {
		NewMessage nm = new NewMessage();
		List<AttachmentTO> list = new ArrayList<AttachmentTO>();
		List<Attachment> fileAttachments = new ArrayList<Attachment>();
		Attachment attachment = null;

		if( null != rawAttachments ) {
			for (Attachment oneAttachment : rawAttachments) {
				if( null == oneAttachment.getContentDisposition() ) {
					//Skip because it is not a file attachment type
					continue;
				}
				fileAttachments.add(oneAttachment);
			}
		}
		
		if(StringUtils.isEmpty(message.getBody())){
			SMApiUtility.throwException(ErrorEnum.BODY_CANT_BE_NULL_100);
		}

		for( Attachment attach : fileAttachments ) {
			//Should only get one attachment other than "message".
			if( !attach.getContentDisposition().getParameter("name").equals("message") ) {
				attachment = attach;
				break;
			}
		}
		
		//At least one attachment to create an attachment for the message
		if( attachment != null ) {
			String mimeType = attachment.getContentType().toString();
			String fileName = attachment.getContentDisposition().getParameter("filename");
			if ( fileName == null || fileName.isEmpty() ) {
				SMApiUtility.throwException(ErrorEnum.FILENAME_IS_REQUIRED_123);
			}

			int mid = 0;
			String ext = null;

			if( fileName.contains(".") ) {
				mid = fileName.lastIndexOf(".")+1;
				ext = fileName.substring(mid,fileName.length()).toUpperCase();
			}

			if(null == ext || ext.isEmpty() || supportedFileTypes.containsKey(ext)) {
				SMApiUtility.throwException(ErrorEnum.UNSUPPORTED_ATTACHMENT_FILE_TYPE_122);
			}

			byte[] bytes = null;

			try {
				InputStream image = attachment.getDataHandler().getInputStream();
				bytes = SMApiUtility.extractByteArray(image);

				if( bytes.length > FILE_SIZE_LIMIT_3MB ) {
					SMApiUtility.throwException(ErrorEnum.MESSAGE_ATTACHMENT_EXCEEDS_SIZE_124);
				}
			} catch (IOException e) {
				SMApiUtility.throwException(ErrorEnum.MESSAGE_ATTACHMENT_ERROR_113);
			}

			ServiceResponse<MessageAttachment> response = messageService.saveAttachment(bytes, fileName, mimeType);
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
			MessageAttachment attachmentSaved = response.getPayload();

			nm.setAttachmentId(attachmentSaved.getId());
			nm.setAttachmentName(attachmentSaved.getAttachmentName());

			list.add(new AttachmentTO(attachmentSaved.getId(), attachmentSaved.getAttachmentName()));
		}

		nm.setBody(message.getBody());
		nm.setSubject(StringUtils.isEmpty(message.getSubject())?(message.getCategory().getName()+" Inquiry"):message.getSubject());
		nm.setMessageCategoryTypeId(message.getCategory().getId());
		nm.setFrom(p);

		CollectionServiceResponse<TriageGroup> response1 = triageGroupService.getTriageGroupsForPatient(p);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response1);
		for(TriageGroup tg : response1.getCollection()){
			if(tg.getId().equals(message.getRecipientId())){
				nm.setTo(tg);
				nm.setTriageGroup(tg);
				break;
			}
		}

		if( nm.getTo() == null ) {
			SMApiUtility.throwException(ErrorEnum.TRIAGE_TEAM_NOT_FOUND_119);
		}

		Message m = null;
		
		/* DETECT IF IT IS A DRAFT (PRESENCE OF A ID) AND SEND DRAFT */
		if( message.getId() != null && message.getId() != 0l) {
			
			ServiceResponse<Message> response = messageService.fetchMessage(message.getId());
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
			Message m1 = response.getPayload();

			if ( null != m1 ) {
				if( m1.getSenderId().equals(p.getId()) || m1.getRecipientId().equals(p.getId()) ) {
					Long currentFolderId = null;
					//Make sure it is a draft folder message
					for(Addressee addr:m1.getAddressees()) {
						if( addr.getOwner().getId().equals(p.getId()) ) {
							currentFolderId = addr.getFolderId();
							break;
						}
					}
					if( currentFolderId == null ) {
						SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}
					
					if( m1.getSentDate() != null || !currentFolderId.equals(SystemFolderEnum.DRAFTS.getId())) {
						SMApiUtility.throwException(ErrorEnum.MESSAGE_IS_NOT_A_DRAFT_SEND_128);
					}
					ServiceResponse<Message> response2 = sendMessageService.sendDraft(nm, m1.getId());
					SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, response2);
					m = response2.getPayload();
				}
			}
		} else {
			ServiceResponse<Message>response2 = sendMessageService.send(nm);
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, response2);
			m = response2.getPayload();
		}

		if( m == null ) {
			SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		
		ServiceResponse<TriageGroup> response3 = triageGroupService.findTriageGroupById(m.getThread().getMailGroup().getId());
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response3);
		TriageGroup tg = response3.getPayload();

		//Populate the MessageTO
		PatientMessageTO messageTO = new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), 
				m.getThread().getSubject(), m.getBody(), !list.isEmpty(), new AttachmentsTO(list), 
				p.getId(), p.getName(), tg.getId(), tg.getName(), m.getSentDate(), m.getReadReceipt());

		return messageTO;
	}

	/**
	 * Session Error Codes: 108, 109, 110
	 * Error Codes: 112, 114, 900, 904
	 */
	@Override
	public Response deleteMessage(Long messageId) {
		ServiceResponse<Message> response2 = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response2);
		Message m = response2.getPayload();
		
		if (m.getSentDate() == null) {
			return deleteDraftMessage(messageId, SystemFolderEnum.DELETED.getId());
		}
		else 
			return moveMessage(messageId, SystemFolderEnum.DELETED.getId());
	}

	/**
	 * Session Error Codes: 102, 108, 109, 110, 111
	 * Error Codes: 112, 115, 114, 117, 118, 900, 904
	 */
	@Override
	public Response moveMessage(Long messageId, Long folderId) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		ServiceResponse<Patient> response = mailboxService.getMailbox(p, false);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);

		Map<Long,Folder> map = p.getMailbox().getFolders();
		Folder moveFolder = map.get(folderId);
		if( null == moveFolder ) {
			SMApiUtility.throwException(ErrorEnum.NOT_FOUND_115);
		}

		ServiceResponse<Message> response2 = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response2);
		Message m = response2.getPayload();

		//CHECK IF THEY ARE THE OWNER
		if( m.getSenderId().equals(p.getId()) || m.getRecipientId().equals(p.getId()) ) {
			Long messageFolderId = null;
			List<Addressee> list = m.getAddressees();
			for(Addressee addressee : list) {
				if( addressee.getOwner().getId().equals(p.getId()) ) {
					messageFolderId = addressee.getFolderId();
				}
			}
	
			if( null == messageFolderId ) {
				SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
			}
	
			ServiceResponse<Boolean> response3 = null;
			//Cannot move message from DRAFT folder
			if(messageFolderId.equals(SystemFolderEnum.DRAFTS.getId()) ){
				SMApiUtility.throwException(ErrorEnum.NOT_ABLE_TO_MOVE_DRAFT_MESSAGES_118);
			}
			//Cannot move message from DRAFT folder
			else if(messageFolderId.equals(SystemFolderEnum.SENT.getId()) ){
				SMApiUtility.throwException(ErrorEnum.MESSAGE_MOVE_ERROR_114);
			}
			else {
				response3 = messageService.moveMessage(m, p, moveFolder);
			}
	
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response3);
			if( !response3.getPayload().booleanValue() ) {
				SMApiUtility.throwException(ErrorEnum.MESSAGE_MOVE_ERROR_114);
			}
		} else {
			SMApiUtility.throwException(ErrorEnum.NOT_OWNER_OF_ENTITY_112);
		}
		
		return Response.ok("Success").build();
	}

	/**
	 * Session Error Codes: 108, 109, 110
	 * Error Codes: 904, 112, 115
	 */
	@Override
	public Response getMessageAttachment(Long messageId, Long attachmentId) {
		MessageAttachment ma = null;
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();

		ServiceResponse<Message> response = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
		Message m = response.getPayload();

		if( m.getSenderId().equals(p.getId()) || m.getRecipientId().equals(p.getId()) ) {
			if( attachmentId.equals(m.getAttachmentId()) ) {
				ServiceResponse<MessageAttachment> response3 = messageService.fetchAttachment(m.getAttachmentId());
				SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response3);
				ma = response3.getPayload();
			} else {
				SMApiUtility.throwException(ErrorEnum.NOT_FOUND_115);
			}
		} else {
			SMApiUtility.throwException(ErrorEnum.NOT_OWNER_OF_ENTITY_112);
		}

		try {
			if( log.isInfoEnabled() ) {
			log.info("Message Attachment: {name=" + ma.getAttachmentName()+";size="+ ma.getAttachment().length() + ";type=" + ma.getMimeType()+"}");
			}
			return Response.ok().entity(ma.getAttachment()).header("Content-Type","application/octet-stream").header("Content-Length", ma.getAttachment().length()).header("Content-Disposition","attachment; filename="+ma.getAttachmentName()).build();
		}
		catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null; 

	}

	@Override
	public PatientMessageTO replyMessage(Long messageId, PatientMessageTO message) {
		Session session = sessionApiService.checkSession(mc);
		Patient pat = session.getPatient();

		return replyMessage(messageId, message, pat, null);
	}

	@Override
	public PatientMessageTO replyMessageWithAttachment(Long messageId, PatientMessageTO message, final List<Attachment> rawAttachments) {
		Session session = sessionApiService.checkSession(mc);
		Patient pat = session.getPatient();

		return replyMessage(messageId, message, pat, rawAttachments);
	}

	private PatientMessageTO replyMessage(Long messageId, PatientMessageTO message, Patient pat, final List<Attachment> rawAttachments) {
		ServiceResponse<Message> rsp = messageService.fetchMessage(new Long(messageId));
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, rsp);
		
		Message currentMessage = rsp.getPayload();
		Long currentFolderId = null;
		//
		Thread messageThread = threadService.findThreadById(currentMessage.getThread().getId());
		
		if(StringUtils.isEmpty(message.getBody())){
			SMApiUtility.throwException(ErrorEnum.BODY_CANT_BE_NULL_100);
		}
		
		ServiceResponse<TriageGroup> trgRes = triageGroupService.findTriageGroupById(messageThread.getMailGroup().getId());
		TriageGroup mailGroup = trgRes.getPayload();
		
		//To check whether mail group is active
		if(!mailGroup.isActive()){
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_NOT_ASSOCIATED_TRIAGE_TEAM_129);
		}

		ServiceResponse<TriageGroup> triageGroup = triageGroupService.getRelationsForTriageGroup(mailGroup);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, triageGroup);
		
		/*		
 		boolean userTriageGroupFlag = false;
		for(TriageRelation tr : triageGroup.getPayload().getRelations()) {	
			if( tr.getVistaIen().equals(pat.getId().toString())) {
				userTriageGroupFlag = true;
				break;
			}
		}*/

		boolean userTriageGroupFlag = false;
		CollectionServiceResponse<TriageGroup> response1 = triageGroupService.getTriageGroupsForPatient(userManagementService.findPatientById(pat.getId()));
		for(TriageGroup tg : response1.getCollection()){
			if(tg.getId().equals(currentMessage.getThread().getMailGroup().getId())){
				userTriageGroupFlag = true;
				break;
			}
		}
		
		if(!userTriageGroupFlag){
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_NOT_ASSOCIATED_TRIAGE_TEAM_129);
		}

		for(Addressee addr:currentMessage.getAddressees()) {
			if( addr.getOwner().getId().equals(pat.getId()) ) {
				currentFolderId = addr.getFolderId();
				break;
			}
		}
		if( currentFolderId == null ) {
			SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}

		//Check that the message is not expired
		if(isMessageExpired(currentMessage)) {
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_EXPIRED_MESSAGE_130);
		}

		NewMessage newMessage = new NewMessage();
		newMessage.setFrom(pat);
		newMessage.setMessageCategoryTypeId(currentMessage.getThread().getMessageCategoryType().getId());
		newMessage.setSubject(currentMessage.getThread().getSubject());
		newMessage.setTriageGroup(currentMessage.getThread().getMailGroup());
		newMessage.setBody(message.getBody());
		newMessage.setTo(mailGroup);
		
		
		List<AttachmentTO> list = new ArrayList<AttachmentTO>();
		List<Attachment> fileAttachments = new ArrayList<Attachment>();

		if( null != rawAttachments ) {
			for (Attachment attachment : rawAttachments) {
				if( null == attachment.getContentDisposition() ) {
					//Skip because it is not a file attachment type
					continue;
				}
				fileAttachments.add(attachment);
			}
		}

		if( !fileAttachments.isEmpty() ) {
			for( Attachment a : fileAttachments ) {
				String mimeType = a.getContentType().toString();
				String fileName = a.getContentDisposition().getParameter("filename");
				if ( fileName == null || fileName.isEmpty() ) {
					SMApiUtility.throwException(ErrorEnum.FILENAME_IS_REQUIRED_123);
				}

				int mid = 0;
				String ext = null;

				if( fileName.contains(".") ) {
					mid = fileName.lastIndexOf(".")+1;
					ext = fileName.substring(mid,fileName.length()).toUpperCase();
				}

				if(null == ext || ext.isEmpty() || supportedFileTypes.containsKey(ext)) {
					SMApiUtility.throwException(ErrorEnum.UNSUPPORTED_ATTACHMENT_FILE_TYPE_122);
				}

				byte[] bytes = null;

				try {
					InputStream image = a.getDataHandler().getInputStream();
					bytes = SMApiUtility.extractByteArray(image);

					if( bytes.length > FILE_SIZE_LIMIT_3MB ) {
						SMApiUtility.throwException(ErrorEnum.MESSAGE_ATTACHMENT_EXCEEDS_SIZE_124);
					}
				} catch (IOException e) {
					SMApiUtility.throwException(ErrorEnum.MESSAGE_ATTACHMENT_ERROR_113);
				}

				ServiceResponse<MessageAttachment> response2 = messageService.saveAttachment(bytes, fileName, mimeType);
			
				SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, triageGroup);
				
				MessageAttachment attachment = response2.getPayload();

				newMessage.setAttachmentId(attachment.getId());
				newMessage.setAttachmentName(attachment.getAttachmentName());

				list.add(new AttachmentTO(attachment.getId(), attachment.getAttachmentName()));
			}
		}

		ServiceResponse<Message> result = new ServiceResponse<Message>();
		if( currentFolderId.equals(SystemFolderEnum.SENT.getId()) ){
			result = sendMessageService.replyFromSentFolder(currentMessage, newMessage);
		} else if( message.getId() == null && currentFolderId.equals(SystemFolderEnum.DRAFTS.getId()) ){
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_TO_A_DRAFT_MESSAGE_131);
		} 

		// Adding for Draft Crap...muazzam
				/* SEND DRAFT */
		
		
		// Ended Here.....
		
		// Adding for Draft Crap...
		/* SEND DRAFT */
		if( message.getId() != null && message.getId() != 0l) {
			
			ServiceResponse<Message> response = messageService.fetchMessage(message.getId());
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
			Message m1 = response.getPayload();

			if ( null != m1 ) {
				if( m1.getSenderId().equals(pat.getId()) || m1.getRecipientId().equals(pat.getId()) ) {
					//Make sure it is a draft folder message
					for(Addressee addr:m1.getAddressees()) {
						if( addr.getOwner().getId().equals(pat.getId()) ) {
							currentFolderId = addr.getFolderId();
							break;
						}
					}
					if( currentFolderId == null ) {
						SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}
					
					if( m1.getSentDate() != null || !currentFolderId.equals(SystemFolderEnum.DRAFTS.getId())) {
						SMApiUtility.throwException(ErrorEnum.MESSAGE_IS_NOT_A_DRAFT_SEND_128);
					}
					ServiceResponse<Message> response2 = sendMessageService.sendReplyDraftForAPI(currentMessage, newMessage);
					SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, response2);
					Message result2 = response2.getPayload();
					result.setPayload(result2);
				}
			}
		}
		// Ended Here
		
		else {
			result = sendMessageService.reply(currentMessage, newMessage);
		}

		SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, result);

		Message m = result.getPayload();

		PatientMessageTO messageTO = new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), 
				m.getThread().getSubject(), m.getBody(), !list.isEmpty(), new AttachmentsTO(), 
				pat.getId(), pat.getName(), mailGroup.getId(),mailGroup.getName(), m.getSentDate(), m.getReadReceipt());
 
		return messageTO;
	}

	/**
	 * Session Error Codes: 108, 109, 110
	 * Error Codes: 904, 112, 115
	 */
	@Override
	public MessagesTO getMessageHistory(Long messageId) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();

		List<MessageTO> messagesList = new ArrayList<MessageTO>();

		ServiceResponse<Message> response = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
		Message message = response.getPayload();

		if ( null != message ) {
			if( message.getSenderId().equals(p.getId()) || message.getRecipientId().equals(p.getId()) ) {
				Thread thread = message.getThread();
				if (thread != null) {
					List<Message> result = new ArrayList<Message>();
					for (Message msg : thread.getMessages()) {
						if (msg.getCreatedDate().before(message.getCreatedDate()) && msg.getSentDate() != null){
							result.add(msg);
						}
					}

					Collections.sort(result, new Comparator<Message>() {
						public int compare(Message msg1, Message msg2) {
							if (msg1 == null)
								return 1;
							else if (msg2 == null)
								return -1;
							else {
								Date date1 = msg1.getSentDate();
								Date date2 = msg2.getSentDate();
								if (date2.after(date1))
									return 1;
								else if (date2.before(date1))
									return -1;
								else
									return 0;
							}
						}
					});

					for( Message m : result ) {
						messagesList.add(new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(),
								m.getThread().getSubject(), m.getBody(), 
								m.isAttachment(), null, m.getSenderId(), 
								m.getSenderName(), m.getRecipientId(), 
								m.getRecipientName(), m.getSentDate(), m.getReadReceipt()));
					}
				}
			}
			else {
				SMApiUtility.throwException(ErrorEnum.NOT_OWNER_OF_ENTITY_112);
			}
		} else {
			SMApiUtility.throwException(ErrorEnum.NOT_FOUND_115);
		}

		return new MessagesTO(messagesList);
	}

	/**
	 * Session Error Codes: 108, 109, 110
	 * Error Codes: 117
	 */
	@Override
	public MessageCategoryTypesTO getMessageCategoryTypes() {
		Session session = sessionApiService.checkSession(mc);

		if( messageCategoryTypeEnumList.isEmpty() ) {
			SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}
		return new MessageCategoryTypesTO(messageCategoryTypeEnumList);
	}

	@Override
	public PatientMessageTO saveDraftMessage(PatientMessageTO message) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		
		NewMessage nm = new NewMessage();
		Message m = null;
		
		if(StringUtils.isEmpty(message.getBody())){
			SMApiUtility.throwException(ErrorEnum.BODY_CANT_BE_NULL_100);
		}

		//IF ID IS SET THEN TRY TO UPDATE THE CURRENT DRAFT INSTEAD OF CREATE
		if( message.getId() != null && message.getId() != 0l) {
			ServiceResponse<Message> response = messageService.fetchMessage(message.getId());
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
			Message m1 = response.getPayload();

			if ( null != m1 ) {
				if( m1.getSenderId().equals(p.getId()) || m1.getRecipientId().equals(p.getId()) ) {
					Long currentFolderId = null;
					//Make sure it is a draft folder message
					for(Addressee addr:m1.getAddressees()) {
						if( addr.getOwner().getId().equals(p.getId()) ) {
							currentFolderId = addr.getFolderId();
							break;
						}
					}
					if( currentFolderId == null ) {
						SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}
					
					if( m1.getSentDate() != null || !currentFolderId.equals(SystemFolderEnum.DRAFTS.getId())) {
						SMApiUtility.throwException(ErrorEnum.MESSAGE_IS_NOT_A_DRAFT_SAVE_134);
					}

					//CONTINUE THE SAVE WILL HAPPEN BASED ON THE PRESENCE OF AN ID OTHERWISE IT WILL BE NULL
				}
			}
		} 
		
		nm.setBody(message.getBody());
		nm.setSubject(StringUtils.isEmpty(message.getSubject())?(message.getCategory().getName()+" Inquiry"):message.getSubject());
		nm.setMessageCategoryTypeId(message.getCategory().getId());
		nm.setFrom(p);

		CollectionServiceResponse<TriageGroup> response1 = triageGroupService.getTriageGroupsForPatient(p);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response1);
		for(TriageGroup tg : response1.getCollection()){
			if(tg.getId().equals(message.getRecipientId())){
				nm.setTo(tg);
				nm.setTriageGroup(tg);
				break;
			}
		}

		if( nm.getTo() == null ) {
			SMApiUtility.throwException(ErrorEnum.TRIAGE_TEAM_NOT_FOUND_119);
		}

		//If action is an update then message.getId will provide the indicator to update.
		ServiceResponse<Message> response2 = sendMessageService.saveDraft(nm, message.getId());
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, response2);
		m = response2.getPayload();
		
		ServiceResponse<TriageGroup> response3 = triageGroupService.findTriageGroupById(m.getThread().getMailGroup().getId());
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response3);
		TriageGroup tg = response3.getPayload();
		
		//Populate the MessageTO
		return new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), 
				m.getThread().getSubject(), m.getBody(), false, new AttachmentsTO(), 
				p.getId(), p.getName(), tg.getId(), tg.getName(), m.getSentDate(), m.getReadReceipt());

	}

	@Override
	public PatientMessageTO saveReplyDraft(Long currentMessageId, PatientMessageTO message) {
		Session session = sessionApiService.checkSession(mc);
		Patient pat = session.getPatient();

		NewMessage nm = new NewMessage();
		Message m = null;

		if(StringUtils.isEmpty(message.getBody())){
			SMApiUtility.throwException(ErrorEnum.BODY_CANT_BE_NULL_100);
		}
		
		ServiceResponse<Message> rsp = messageService.fetchMessage(new Long(currentMessageId));
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, rsp);
		Message currentMessage = rsp.getPayload();
		Long currentFolderId = null;
		
		Thread messageThread = threadService.findThreadById(currentMessage.getThread().getId());
		ServiceResponse<TriageGroup> trgRes = triageGroupService.findTriageGroupById(messageThread.getMailGroup().getId());
		TriageGroup mailGroup = trgRes.getPayload();

		//To check whether mail group is active
		if(!mailGroup.isActive()){
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_NOT_ASSOCIATED_TRIAGE_TEAM_129);
		}

		ServiceResponse<TriageGroup> triageGroup = triageGroupService.getRelationsForTriageGroup(mailGroup);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, triageGroup);

		for(Addressee addr:currentMessage.getAddressees()) {
			if( addr.getOwner().getId().equals(pat.getId()) ) {
				currentFolderId = addr.getFolderId();
				break;
			}
		}
		if( currentFolderId == null ) {
			SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
		}

		//Check that the message is not expired
		if(isMessageExpired(currentMessage)) {
			SMApiUtility.throwException(ErrorEnum.UNABLE_TO_REPLY_EXPIRED_MESSAGE_130);
		}

		Message m1 = null;
		//IF ID IS SET THEN TRY TO UPDATE THE CURRENT DRAFT INSTEAD OF CREATE
		if( message.getId() != null && message.getId() != 0l) {
			ServiceResponse<Message> response = messageService.fetchMessage(message.getId());
			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);
			m1 = response.getPayload();

			if ( null != m1 ) {
				boolean isRecipient = false;
				for(Addressee addr:m1.getAddressees()) {
					if( addr.getOwner().getId().equals(pat.getId()) ) {
						isRecipient=true;
						break;
					}
				}
				if( isRecipient ) {
					Long draftMesgFolderId = null;
					//Make sure it is a draft folder message
					for(Addressee addr:m1.getAddressees()) {
						if( addr.getOwner().getId().equals(pat.getId()) ) {
							draftMesgFolderId = addr.getFolderId();
							break;
						}
					}
					if( draftMesgFolderId == null ) {
						SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
					}

					if( m1.getSentDate() != null || !draftMesgFolderId.equals(SystemFolderEnum.DRAFTS.getId())) {
						SMApiUtility.throwException(ErrorEnum.MESSAGE_IS_NOT_A_DRAFT_SAVE_134);
					}

					//CONTINUE THE SAVE WILL HAPPEN BASED ON THE PRESENCE OF AN ID OTHERWISE IT WILL BE NULL
				}

			}
		} 

		nm.setBody(message.getBody());
		nm.setSubject(messageThread.getSubject());
		nm.setMessageCategoryTypeId(messageThread.getMessageCategoryType().getId());
		nm.setFrom(pat);

		CollectionServiceResponse<TriageGroup> response1 = triageGroupService.getTriageGroupsForPatient(pat);
		
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response1);
		for(TriageGroup tg : response1.getCollection()){
			if(tg.getId().equals(triageGroup.getPayload().getId())){
				nm.setTo(tg);
				nm.setTriageGroup(tg);
				break;
			}
		}

		if( nm.getTo() == null ) {
			SMApiUtility.throwException(ErrorEnum.TRIAGE_TEAM_NOT_FOUND_119);
		}

		ServiceResponse<Message> response2 = null;
		//If action is an update then message.getId will provide the indicator to update.
		if( message.getId() != null && message.getId() != 0l) {
			response2 = sendMessageService.saveReplyDraft(m1, nm);
		}
		else {
			response2 = sendMessageService.saveReplyDraft(currentMessage, nm);
		}
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.SEND_MESSAGE_SERVICE_ERROR_903, response2);
		m = response2.getPayload();

		ServiceResponse<TriageGroup> response3 = triageGroupService.findTriageGroupById(m.getThread().getMailGroup().getId());
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.TRIAGEGROUP_SERVICE_ERROR_902, response3);
		TriageGroup tg = response3.getPayload();

		//Populate the MessageTO
		//Populate the MessageTO
		return new PatientMessageTO(m.getId(), m.getThread().getMessageCategoryType(), 
				m.getThread().getSubject(), m.getBody(), false, new AttachmentsTO(), 
				pat.getId(), pat.getName(), tg.getId(), tg.getName(), m.getSentDate(), m.getReadReceipt());		
	}
	
	public Response deleteDraftMessage(Long messageId, Long folderId) {
		Session session = sessionApiService.checkSession(mc);
		Patient p = session.getPatient();
		ServiceResponse<Patient> response = mailboxService.getMailbox(p, false);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response);

		Map<Long,Folder> map = p.getMailbox().getFolders();
		Folder moveFolder = map.get(folderId);
		if( null == moveFolder ) {
			SMApiUtility.throwException(ErrorEnum.NOT_FOUND_115);
		}

		ServiceResponse<Message> response2 = messageService.fetchMessage(messageId);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response2);
		Message m = response2.getPayload();

		//CHECK IF THEY ARE THE OWNER
		if( m.getSenderId().equals(p.getId()) || m.getRecipientId().equals(p.getId()) ) {
			Long messageFolderId = null;
			List<Addressee> list = m.getAddressees();
			for(Addressee addressee : list) {
				if( addressee.getOwner().getId().equals(p.getId()) ) {
					messageFolderId = addressee.getFolderId();
				}
			}
	
			if( null == messageFolderId ) {
				SMApiUtility.throwException(ErrorEnum.DATA_INTEGRITY_ERROR_117);
			}
	
			ServiceResponse<Boolean> response3 = null;
			
			if(messageFolderId.equals(SystemFolderEnum.DRAFTS.getId())){
				//SMApiUtility.throwException(ErrorEnum.NOT_ABLE_TO_MOVE_DRAFT_MESSAGES_118);
				
				response3 = messageService.deleteDraft(p, m.getId());	
			}

			SMApiUtility.throwExceptionOnErrors(ErrorEnum.MESSAGE_SERVICE_ERROR_904, response3);
			if( !response3.getPayload().booleanValue() ) {
				SMApiUtility.throwException(ErrorEnum.MESSAGE_MOVE_ERROR_136);
			}
		} else {
			SMApiUtility.throwException(ErrorEnum.NOT_OWNER_OF_ENTITY_112);
		}
		
		return Response.ok("Success").build();
	}
	
	public SessionAPIService getSessionApiService() {
		return sessionApiService;
	}
	public void setSessionApiService(SessionAPIService sessionApiService) {
		this.sessionApiService = sessionApiService;
	}
	public gov.va.med.mhv.sm.service.MessageService getMessageService() {
		return messageService;
	}
	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}
	public SendMessageService getSendMessageService() {
		return sendMessageService;
	}
	public void setSendMessageService(SendMessageService sendMessageService) {
		this.sendMessageService = sendMessageService;
	}
	public TriageGroupService getTriageGroupService() {
		return triageGroupService;
	}
	public void setTriageGroupService(TriageGroupService triageGroupService) {
		this.triageGroupService = triageGroupService;
	}
	public MailboxService getMailboxService() {
		return mailboxService;
	}
	public void setMailboxService(MailboxService mailboxService) {
		this.mailboxService = mailboxService;
	}
	public ThreadService getThreadService() {
		return threadService;
	}
	public void setThreadService(ThreadService threadService) {
		this.threadService = threadService;
	}

	public UserManagementService getUserManagementService() {
		return userManagementService;
	}

	public void setUserManagementService(UserManagementService userManagementService) {
		this.userManagementService = userManagementService;
	}

}
