package gov.va.med.mhv.sm.api.interceptor;

import gov.va.med.mhv.sm.api.cache.CacheHandler;
import gov.va.med.mhv.sm.api.transfer.ErrorTO;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.service.LoggingService;
import gov.va.med.mhv.sm.thread.CacheSMDomainHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * 
 * RECEIVE (PRE/USER/POST)_STREAM READ (PRE/USER/POST)_PROTOCOL UNMARSHAL
 * (PRE/USER/POST)_LOGICAL PRE_INVOKE INVOKE POST_INVOKE
 */
public class ResponseInterceptor extends AbstractPhaseInterceptor<Message> {
	private Log log = LogFactory.getLog(ResponseInterceptor.class);
	private LoggingService loggingService;

	public ResponseInterceptor() {
		super(Phase.SEND_ENDING);
	}

	public void handleMessage(Message outboundMessage) {
		if( log.isInfoEnabled()) {
			log.info("[Thread " + Thread.currentThread().getId() + "] LogOutInterceptor ");
		}
		
		CacheSMDomainHandler.resetInstance();
		
		Message inboundMessage = CacheHandler.getInstance().getInboundMessage();
		ErrorTO error = CacheHandler.getInstance().getError();

		if( log.isInfoEnabled()) {
			log.info((error == null ? "SUCCESS" : "ERROR") + ": "
				+ CacheHandler.getInstance().getSession()
				+ "; Request: "
				+ String.valueOf(inboundMessage.get(Message.HTTP_REQUEST_METHOD))
				+ " "
				+ String.valueOf(inboundMessage.get(Message.REQUEST_URI))
				+ "; Response: "
				+ Integer.parseInt(String.valueOf(outboundMessage.get(Message.RESPONSE_CODE)))
				+ (error != null ? "; Error: " + error : ""));
		}
		
		if( error == null ) {
			//SUCCESS
			//Probably a combination of pattern and method to record AAL events 
			if( String.valueOf(inboundMessage.get(Message.REQUEST_URI)).contains("/session") && 
					String.valueOf(inboundMessage.get(Message.HTTP_REQUEST_METHOD)).equals("GET") && CacheHandler.getInstance().getSession().isPatient() ) {
				loggingService.logInFromAPI( ((Patient)CacheHandler.getInstance().getSession().getUser()).getUserProfileId(), CacheHandler.getInstance().getSession().getClientApplication().getName());
			}
		}
		
	}

	public void handleFault(Message outboundMessage) {
		CacheSMDomainHandler.resetInstance();
		//Nothing to do here
	}
	
	public LoggingService getLoggingService() {
		return loggingService;
	}
	public void setLoggingService(LoggingService logginService) {
		this.loggingService = logginService;
	}
}
